<?php
/**
 * Test table class to be put in test_table.php of root of Moodle installation.
 *  for defining some custom column names and proccessing
 * Username and Password feilds using custom and other column methods.
 */
class test_table extends table_sql {

    /**
     * Constructor
     * @param int $uniqueid all tables have to have a unique id, this is used
     *      as a key when storing table properties like sort order in the session.
     */
    function __construct($uniqueid) {
        parent::__construct($uniqueid);
        // Define the list of columns to show.
        $columns = array('title','Incomplete', 'Complete', 'totaltime','noofuser','attempt');
        $this->define_columns($columns);

        // Define the titles of columns to show in header.
        $headers = array('Title','Incomplete Attempts', 'Complete Attempts', 'Total Time (in minutes)','No. of users','Attempts');
        $this->define_headers($headers);
    }

    /**
     * This function is called for each data row to allow processing of the
     * username value.
     *
     * @param object $values Contains object with all the values of record.
     * @return $string Return username with link to profile or username only
     *     when downloading.
     */
    function col_title($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $values->name;
        } else {
            return $values->name;
        }
    }

    /**
     * This function is called for each data row to allow processing of
     * columns which do not have a *_cols function.
     * @return string return processed value. Return NULL if no change has
     *     been made.
     */
    function col_Complete($values) {
        global $DB,$CFG;


$totaluser = $DB->get_record_sql("SELECT count(userid) as total from 
{scorm_scoes_track} where scormid=$values->id and element='cmi.core.lesson_status' and 
(value='completed' or value='passed')");


        if ($this->is_downloading()) {
            
            return $totaluser->total;
        } else {
            return $totaluser->total;
        }
    }

    function col_Incomplete($values) {
        global $DB,$CFG;

$totaluser = $DB->get_record_sql("SELECT count(userid) as total from 
{scorm_scoes_track} where scormid=$values->id and element='cmi.core.lesson_status' and value='incomplete'");


        if ($this->is_downloading()) {
            
            return $totaluser->total;
        } else {
            return $totaluser->total;
        }
    }

    function col_totaltime($values) {

        global $DB,$CFG;
$totaluser = $DB->get_record_sql("SELECT SUM(TIME_TO_SEC(value))/60 as total  from {scorm_scoes_track} where scormid=$values->id and element='cmi.core.total_time'");
$totaltime = $totaluser->total;
        if ($this->is_downloading()) {
            return $totaluser->total;
        } else {
            return $totaluser->total;
        }
    }


    function col_noofuser($values) {

        global $DB,$CFG;
        $contextid  = context_course::instance($values->course);
        $enrolids = count_enrolled_users($contextid);
        if ($this->is_downloading()) {
            return $enrolids;
        } else {
            return $enrolids;
        }
    }

    function col_attempt($values) {

        global $DB,$CFG;
        $incomplete_stu = $DB->get_record_sql("SELECT count(userid) as total from 
        {scorm_scoes_track} where scormid=$values->id and element='cmi.core.lesson_status' and value='incomplete'");

$complete_stu = $DB->get_record_sql("SELECT count(userid) as total from 
{scorm_scoes_track} where scormid=$values->id and element='cmi.core.lesson_status' and 
(value='completed' or value='passed')");

$incomplete = (int)$incomplete_stu->total;
$complete = (int)$complete_stu->total;
$total_attempt = $incomplete+$complete;
        if ($this->is_downloading()) {
            return $total_attempt;
        } else {
            return $total_attempt;
        }
    }

}