<?php

/**
 * Simple file test_custom.php to drop into root of Moodle installation.
 * This is an example of using a sql_table class to format data.
 */
require_once("../../config.php");
require "$CFG->libdir/tablelib.php";
require "class.php";

$title = 'User Registration Report';
$pagetitle = $title;
$PAGE->set_title($title);
$PAGE->set_heading($title);
$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_url('/local/username');
$PAGE->set_pagelayout('standard');
$download = optional_param('download', '', PARAM_ALPHA);

$table = new test_table('uniqueid');

$table->is_downloading($download, 'test', 'testing123');

if (!$table->is_downloading()) {
    // Only print headers if not asked to download data.
    // Print the page header.
    $PAGE->set_title('User Registration Report');
    $PAGE->set_heading('User Registration Report');
    $PAGE->navbar->add('User Registration Report', new moodle_url('local/username/index.php'));
    $previewnode = $PAGE->navigation->add('User Registration Report', new moodle_url('/local/username/index.php'), navigation_node::TYPE_CONTAINER);
$previewnode->make_active();
    echo $OUTPUT->header();
}

// Work out the sql for the table.
$table->set_sql('*', "{user}", '1=1');

$table->define_baseurl("$CFG->wwwroot/local/username/index.php");

$table->out(10, true);

if (!$table->is_downloading()) {
    echo $OUTPUT->footer();
}