<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Event observers used in forum.
 *
 * @package    local_aws_plugin
 * @copyright  2013 Rajesh Taneja <rajesh@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * Event observer for local_aws_plugin.
 */
namespace local_aws_plugin;
class observers {


    /**
     * Triggered via assignsubmission_file event.
     *
     * @param \assignsubmission_file\event\assessable_uploaded $event2
     */
    public static function fileuplodeds(\assignsubmission_file\event\assessable_uploaded $event2) {
        global $DB, $CFG;
        if (empty($event2)) {
            return;
        } else {
            require($CFG->dirroot.'/local/aws_plugin/lib.php');
            Global $CFG;
            $eventdata = $event2->get_data();
            aws_connect($eventdata);
        }
    }
}
