<?php
/**
 * Test table class to be put in test_table.php of root of Moodle installation.
 *  for defining some custom column names and proccessing
 * Username and Password feilds using custom and other column methods.
 */
class test_table extends table_sql {

    /**
     * Constructor
     * @param int $uniqueid all tables have to have a unique id, this is used
     *      as a key when storing table properties like sort order in the session.
     */
    function __construct($uniqueid) {
        parent::__construct($uniqueid);
        // Define the list of columns to show.
        $columns = array('sno','fullnamewithlink', 'username', 'email','userpicture','city','department','phone','lastaccess','confirmed','idnumber');
        $this->define_columns($columns);

        // Define the titles of columns to show in header.
        $headers = array('S no.','Full name', 'Username', 'Email address','User picture','City/Town','Department','Phone','Last access','Confirmed','Id number');
        $this->define_headers($headers);
    }

    /**
     * This function is called for each data row to allow processing of the
     * username value.
     *
     * @param object $values Contains object with all the values of record.
     * @return $string Return username with link to profile or username only
     *     when downloading.
     */

   function col_sno($values) {
                 $sno=(($_GET['page'])*10)+$values->num;

        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            
            return $sno;
        } else {
            return $sno;
        }
    }

    
    function col_fullnamewithlink($values) {
          $field_update = new moodle_url("/user/profile.php?id=$values->id");

        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return html_writer::div("<a href='$field_update'>$values->firstname $values->lastname</a>");    
            
            } else {

                $field_update = new moodle_url("/user/profile.php?id=$values->id");
                return html_writer::div("<a href='$field_update'>$values->firstname $values->lastname</a>");        }
    }

    /**
     * This function is called for each data row to allow processing of
     * columns which do not have a *_cols function.
     * @return string return processed value. Return NULL if no change has
     *     been made.
     */
    function col_username($values) {
     
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            
            return $values->username;
        } else {
            return $values->username;
        }
    }
    function col_email($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $values->email;
        } else {
            return $values->email;
        }
    }

    function col_userpicture($values) {
        global $DB,$OUTPUT,$USER,$CFG;
      $user_image =  $OUTPUT->user_picture($values, array('class' => 'userpicture'));
        // If the data is being downloaded than we don't want to show HTML.
        if ($user_image) {
            return $user_image;
        }else{
            return "No Image";
        }
    }
  
    function col_city($values) {
           $countries = get_string_manager()->get_list_of_countries();

            $user_region = $values->country;
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $countries[$user_region];
        } else {
            return $countries[$user_region];
        }
    }
    function col_department($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $values->department;
        } else {
            return $values->department;
        }
    }
    function col_phone($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $values->phone1;
        } else {
            return $values->phone1;
        }
    }
    function col_lastaccess($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
                        return date('m/d/y',$values->lastaccess);
        } else {
                        return date('m/d/y',$values->lastaccess);
        }
    }
    function col_confirmed($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $values->confirmed;
        } else {
            return $values->confirmed;
        }
    }
    function col_idnumber($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $values->id;
        } else {
            return $values->id;
        }
    }
  



    
}