<?php
require_once("$CFG->dirroot/course/classes/external/course_summary_exporter.php");

/**
 * Test table class to be put in test_table.php of root of Moodle installation.
 *  for defining some custom column names and proccessing
 * Username and Password feilds using custom and other column methods.
 */
class test_table extends table_sql {

    /**
     * Constructor
     * @param int $uniqueid all tables have to have a unique id, this is used
     *      as a key when storing table properties like sort order in the session.
     */
    function __construct($uniqueid) {
        parent::__construct($uniqueid);
        // Define the list of columns to show.
        $columns = array('sno','fullnamewithlink', 'categoryname','image', 'idnumber','shortname','startdate','enddate','enrolusers');
        $this->define_columns($columns);

        // Define the titles of columns to show in header.
        $headers = array('S no.','Course fullname', 'Category name','image', 'Course Id Number','Course shortname','Course startdate','Course enddate','Enrolled users');
        $this->define_headers($headers);
    }

    /**
     * This function is called for each data row to allow processing of the
     * username value.
     *
     * @param object $values Contains object with all the values of record.
     * @return $string Return username with link to profile or username only
     *     when downloading.
     */


        function col_sno($values) {
         $sno=(($_GET['page'])*10)+$values->num;
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $sno;
        } else {
            return $sno;
        }
    }
    function col_fullnamewithlink($values) {
                    $field_update = new moodle_url("/course/view.php?id=$values->id");

        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return html_writer::div("<a href='$field_update'>$values->fullname</a>");    
            
            } else {

                $field_update = new moodle_url("/course/view.php?id=$values->id");
                return html_writer::div("<a href='$field_update'>$values->fullname</a>");        }
    }

    /**
     * This function is called for each data row to allow processing of
     * columns which do not have a *_cols function.
     * @return string return processed value. Return NULL if no change has
     *     been made.
     */
    function col_categoryname($values) {
        global $CFG,$DB;
        $cat_name = $DB->get_record_sql("SELECT name from {course_categories} where id = $values->category");
             // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            
            return $cat_name->name;
        } else {
            return $cat_name->name;
        }
    }
    function col_image($values) {
        global $CFG,$DB;
        $course_img =   \core_course\external\course_summary_exporter::get_course_image($values);
        if($course_img){
            return "<img class='' src=".$course_img." alt='' width='50'>";
        }else{
            return "No Image is there";
        }
    }
    function col_idnumber($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $values->id;
        } else {
            return $values->id;
        }
    }

    function col_shortname($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $values->shortname;
        } else {
            return $values->shortname;
        }
    }
  
    function col_startdate($values) {
      
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return date('m/d/y',$values->startdate);
        } else {
            return date('m/d/y',$values->startdate);
        }
    }
    function col_enddate($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
           return date('m/d/y',$values->enddate);
        } else {
           return date('m/d/y',$values->enddate);
        }
    }
    function col_enrolusers($values) {
        global $CFG,$DB;
        require_once "$CFG->libdir/enrollib.php";
        // If the data is being downloaded than we don't want to show HTML.
        $contextid  = context_course::instance($values->id);
        $enrolids = get_enrolled_users($contextid);
        $studentid = $DB->get_field('role', 'id', array('shortname' => 'student'));
        $total=0;
        foreach($enrolids as $enrolid){
            if(user_has_role_assignment($enrolid->id, $studentid)){
            $total+=1;
        }
    }
    
        if ($this->is_downloading()) {
            return $total;
        } else {
            return $total;
        }
    }
    
  



    
}