<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * OTP Login.
 *
 * @package   auth_otpbasedregandlogin
 * @copyright 2020 Digital Tricksters Software Solutions
 * @author    Trideep Das Modak <trideep@digital-tricksters.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace auth_otpbasedregandlogin\loginflow;

/**
 * Login flow for the oauth2 authorization code grant.
 */
class authcode {
    /** @var object Plugin config. */
    public $config;

    /** @var \auth_otpbasedregandlogin\httpclientinterface An HTTP client to use. */
    protected $httpclient;

    public function __construct() {
        $default = [
            'otp_opname' => get_string('pluginname', 'auth_otpbasedregandlogin')
        ];
        $storedconfig = (array)get_config('auth_otpbasedregandlogin');
        $forcedconfig = [
            'field_updatelocal_idnumber' => 'oncreate',
            'field_lock_idnumber' => 'locked',
            'field_updatelocal_lang' => 'oncreate',
            'field_lock_lang' => 'locked',
            'field_updatelocal_firstname' => 'onlogin',
            'field_lock_firstname' => 'unlocked',
            'field_updatelocal_lastname' => 'onlogin',
            'field_lock_lastname' => 'unlocked',
            'field_updatelocal_email' => 'onlogin',
            'field_lock_email' => 'unlocked',
        ];

        $this->config = (object)array_merge($default, $storedconfig, $forcedconfig);
    }

    /**
     * Returns a list of potential IdPs that this authentication plugin supports. Used to provide links on the login page.
     *
     * @param string $wantsurl The relative url fragment the user wants to get to.
     * @return array Array of idps.
     */
    public function loginpage_idp_list($wantsurl) {
        
        if (empty($this->config->otp_account_no) || empty($this->config->otp_token_id) || empty($this->config->otp_sender_no)) {
            return [];
        }

        $otp_opname = (!empty($this->config->otp_opname)) ? $this->config->otp_opname : 'login';
        $icon = new \pix_icon('login', 'randomIcon', 'auth_otpbasedregandlogin');
        return [
            [
                'url' => new \moodle_url('/auth/otpbasedregandlogin/moblogin.php'),
                'icon' => $icon,
                'name' => $otp_opname,
            ]
        ];

    }

}
