<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * OTP Login.
 *
 * @package   auth_otpbasedregandlogin
 * @copyright 2020 Digital Tricksters Software Solutions
 * @author    Trideep Das Modak <trideep@digital-tricksters.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['otpbasedregandlogin_settings'] = 'OTP login Settings';
$string['otpbasedregandlogin_license'] = 'License Settings';
$string['site_admin'] = 'Site Administrator';
$string['plugins'] = 'Plugins';
$string['authentication'] = 'Authentication';
$string['enter_license_key'] = 'Enter License Key';
$string['enter_product_id'] = 'Enter Product ID';
$string['active_license'] = 'Activate';
$string['not_active'] = 'Not Active';
$string['active'] = 'Active';
$string['deactive_license'] = 'Deactivate';
$string['error'] = 'Error! You do not have permission.';
$string['licensenotactive'] = 'License Not Active!';
$string['otpbasedregandloginregistrationsettings'] = 'Registration Settings';
$string['otpbasedregandloginloginsettings'] = 'Login Settings';
$string['otpbasedregandlogintwillosettings'] = 'Twillo Settings';

$string['pluginname'] = 'OTP Based Registration and login';

$string['otp_opname'] = 'Login button text';
$string['otp_opname_desc'] = 'This is an end-user-facing label that identifies the type of credentials the user must use to login. This label is used throughout the user-facing portions of this plugin to identify your provider (OTP Based).';
$string['otp_opname_default'] = 'Login using OTP verification';

$string['otp_account_no'] = 'Twilio Account Sid';
$string['otp_account_no_desc'] = 'This is the account no of your configured Twilio account.';
$string['otp_account_no_default'] = 'ACb5849d24571180d6c4c1fbc41534a23a';

$string['otp_token_id'] = 'Twilio Account Token';
$string['otp_token_id_desc'] = 'This is the Token id of your configured Twilio account.';
$string['otp_token_id_default'] = 'd19abaa4c1444a2af8d251796e9accfa';

$string['otp_sender_no'] = 'Twilio Sender Number';
$string['otp_sender_no_desc'] = 'This is the Sender Number (with country code) of your configured Twilio account.';
$string['otp_sender_no_default'] = '+19718035923';

$string['otpbasedregandlogindescription'] = '<p>Please click on this url to setup your site recaptcha : <a href="'.$CFG->wwwroot.'/admin/search.php?query=recaptcha">Site recaptcha settings</a></p><p>Note: In addition to enabling the plugin, OTP Based Login and Registration must also be selected from the self registration drop-down menu on the \'Manage authentication\' page.</p>';
$string['otpbasedregandloginrecaptcha'] = 'Adds a visual/audioation form element to the sign-up page for OTP Based Login and Registration users. This protects your site against spammers and contributes to a worthwhile cause. See https://www.google.com/recaptcha for more details.';
$string['otpbasedregandloginrecaptcha_key'] = 'Enable reCAPTCHA element';
$string['privacy:metadata'] = 'The OTP Based Registration and login authentication plugin does not store any personal data.';
$string['onlineselfreg'] = '<p>Please click on the link below to your new account.</p>
   <p>If you need help, please contact the site administrator.</p>';

$string['username'] = 'Username';
$string['username_help'] = 'Please create your username.';
$string['email'] = 'Email';
$string['email_help'] = "Email id field is mandatory. You can add any dummy(abc@domain.com) email id even if you don't have one.";
$string['password'] = 'Password';
$string['password_help'] = 'Please create your password.<br>'.print_password_policy();
$string['firstname'] = 'Firstname';
$string['firstname_help'] = 'Please enter your firstname.';
$string['lastname'] = 'Lastname';
$string['lastname_help'] = 'Please enter your lastname.';
$string['phone2'] = 'Mobile no';
$string['phone2_help'] = 'Please enter your mobile number and do not enter your country code along with your mobile number.';
$string['city'] = 'City';
$string['city_help'] = 'Please enter your city.';
$string['country'] = 'Country';
$string['country_help'] = 'Please enter your country.';


$string['licensesettings'] = 'License Settings';
$string['licensesettings_desc'] = 'Activate your license to use this plugin. Click on <a href="'.$CFG->wwwroot.'/auth/otpbasedregandlogin/license.php">License Settings</a> page to activate your license.';
