<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * OTP Login.
 *
 * @package   auth_otpbasedregandlogin
 * @copyright 2020 Digital Tricksters Software Solutions
 * @author    Trideep Das Modak <trideep@digital-tricksters.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(__DIR__ . '/../../config.php');

global $OUTPUT, $CFG, $PAGE, $DB;

require_once(__DIR__ . '/auth.php');
require_once($CFG->libdir.'/authlib.php');
require_once($CFG->dirroot.'/login/lib.php');
require_once($CFG->libdir.'/moodlelib.php');
require_once($CFG->dirroot.'/cohort/lib.php');
require_once($CFG->dirroot.'/group/lib.php');
require_once($CFG->dirroot.'/course/lib.php');
require_once($CFG->dirroot."/lib/enrollib.php");
require_once($CFG->dirroot."/auth/otpbasedregandlogin/country.php");
require_once($CFG->dirroot."/auth/otpbasedregandlogin/Twilio/autoload.php");

use Twilio\Rest\Client;  

if (isloggedin()) {
  redirect($CFG->wwwroot.'/my', 'Something went wrong');
}

$islicenseactived = get_config('auth_otpbasedregandlogin', 'otpbasedregandlogin_license_key_activated');
if ((!isset($islicenseactived) && empty($islicenseactived)) || ($islicenseactived == 0)) {
    redirect($CFG->wwwroot, 'Please activate your license to continue. (Alert your teacher or administrator)');
}

$site = get_site();

$context = context_system::instance();
$PAGE->set_url("$CFG->wwwroot/auth/otpbasedregandlogin/moblogin.php");
$PAGE->set_context($context);
$PAGE->set_pagelayout('login');
$PAGE->set_title("$site->fullname");
$PAGE->set_heading("$site->fullname");

echo $OUTPUT->header();

$authplugin = get_auth_plugin('otpbasedregandlogin');
$sid = get_config('auth_otpbasedregandlogin', 'otp_account_no');
$token = get_config('auth_otpbasedregandlogin', 'otp_token_id');
$from = get_config('auth_otpbasedregandlogin', 'otp_sender_no');

?>

<div class="otp-login-main-body-section" style="background: url(pix/otp-login-bg.jpg) no-repeat top center; 
  background-size: cover;">
  <div class="container">
    <div class="row">
      <div class="col-sm-12">
        <div class="otp-login-in-content-part">
          <form action="" method="POST" id="numberformdata">
            <h2>Please enter your<br/>Phone number to login your account</h2>
            <p>Please select your country code first</p>
            <div class="otp-code-div-cls send-otp-mobile-no-div">
              <select id="countrycode" class="input-code-send-otp-valued" name="countrycode">
                <?php
                foreach($country as $key => $val) {
                  echo '<option value="'.$val.'">'.$key.' ( '.$val.' )</option>';
                }
                ?>
              </select>
              <input id="mobilenumber" class="input-send-otp-valued" type="text" placeholder="XXXXXXXXXX" maxlength="15"  name="mobilenumber" onkeypress="validatenumber(event)" required>
              <span id="errormsg" class="Entered-worng-otp-cls" style="display: none; margin-top: 55px;"></span>
            </div>
            <div class="clearfix"></div>
            <button id="mobnoformbtn" class="validate-otp-cls send-otp-login-cls" type="button">Send OTP to Log In</button>
          </form>
          <form action="" method="POST" id="otpformdata" style="display: none;">
            <h2>Please enter the (OTP)<br/>to verify your account & login</h2>
            <p>One Time Password (OTP) has been sent to your mobile <span>******1234</span>, Please enter the same here to login</p>
            <div class="otp-code-div-cls">
              <input class="input-otp-valued" type="text" name="custotp1" placeholder="-" maxlength="1" required>
              <input class="input-otp-valued" type="text" name="custotp2" placeholder="-" maxlength="1" required>
              <input class="input-otp-valued" type="text" name="custotp3" placeholder="-" maxlength="1" required>
              <input class="input-otp-valued" type="text" name="custotp4" placeholder="-" maxlength="1" required>
              <input class="input-otp-valued" type="text" name="custotp5" placeholder="-" maxlength="1" required>
              <input class="input-otp-valued" type="text" name="custotp6" placeholder="-" maxlength="1" required>
              <span id="errormsg-otp" class="Entered-worng-otp-cls" style="display: none;">Entered a worng OTP!</span>
            </div>
            <input type="hidden" id="custmobilenumber" name="custmobilenumber" value="">
            <div class="clearfix"></div>
            <button id="otpformbtn" class="validate-otp-cls" type="button">Validate OTP</button>
            <a id="resendotpbtn" class="recend-otp-cls">Resend OTP<span id="sendmsgtext" class="copied-success">(Send) </span></a>
          </form>
          <a href="<?php echo $CFG->wwwroot.'/login/index.php'; ?>" class="wrong-number-cls">Login using username & password?</a>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal"></div>

<?php echo $OUTPUT->footer(); ?>

<script src="<?php echo $CFG->wwwroot; ?>/auth/otpbasedregandlogin/js/jquerycdn.min.js"></script>
<script type="text/javascript">


  $(document.body).on('click', '#mobilenumber', function() {
    $("#countrycode").removeClass("worng-error-otp");
    $("#mobilenumber").removeClass("worng-error-otp");
    $("#errormsg").css("display", "none");
  });

  $(document.body).on('click', '#countrycode', function() {
    $("#countrycode").removeClass("worng-error-otp");
    $("#mobilenumber").removeClass("worng-error-otp");
    $("#errormsg").css("display", "none");
  });

  $(document.body).on('click', '#mobnoformbtn', function() {
    $("body").addClass("loading");
    
    $.ajax({
      url: "<?php echo $CFG->wwwroot; ?>/auth/otpbasedregandlogin/moblogincheck.php",
      method: 'POST',
      data: {
        'countrycode' : $("#countrycode option:selected").val(),
        'mobilenumber' : $("input[name='mobilenumber']").val(),
      },
      success: function(json) {
        $("body").removeClass("loading");
        var data = $.parseJSON(json);
        if (data.status == 'error') {
          $("#countrycode").addClass("worng-error-otp");
          $("#mobilenumber").addClass("worng-error-otp");
          document.getElementById("errormsg").innerText = data.errormsg;
          $("#errormsg").css("display", "block");
        } else if (data.status == 'success') {
          $("#custmobilenumber").val(data.phonenumber);
          $("#numberformdata").css("display", "none");
          $("#otpformdata").css("display", "block");
        } else {
          $("#countrycode").addClass("worng-error-otp");
          $("#mobilenumber").addClass("worng-error-otp");
          document.getElementById("errormsg").innerText = 'Something went wrong';
        }
      },
      error: function() {
        $("body").removeClass("loading");
        $("#mobilenumber").addClass("worng-error-otp");
        document.getElementById("errormsg").innerText = 'Something went wrong';
      },
    });
  });

  $(document.body).on('click', '#resendotpbtn', function() {
    $("body").addClass("loading");
    $.ajax({
      url: "<?php echo $CFG->wwwroot; ?>/auth/otpbasedregandlogin/moblogincheck.php",
      method: 'POST',
      data: {
        'countrycode' : $("#countrycode option:selected").val(),
        'mobilenumber' : $("input[name='mobilenumber']").val(),
      },
      success: function(json) {
        $("body").removeClass("loading");
        var data = $.parseJSON(json);
        if (data.status == 'error') {
          $("#countrycode").addClass("worng-error-otp");
          $("#mobilenumber").addClass("worng-error-otp");
          document.getElementById("errormsg").innerText = data.errormsg;
          $("#errormsg").css("display", "block");
          $("#numberformdata").css("display", "block");
          $("#otpformdata").css("display", "none");
        } else if (data.status == 'success') {
          $("#custmobilenumber").val(data.phonenumber);
          $("#numberformdata").css("display", "none");
          $("#otpformdata").css("display", "block");
          $("#sendmsgtext").show().delay(6000).queue(function(n) {
            $(this).hide(); n();
          });
        } else {
          $("#countrycode").addClass("worng-error-otp");
          $("#mobilenumber").addClass("worng-error-otp");
          document.getElementById("errormsg").innerText = 'Something went wrong';
          $("#numberformdata").css("display", "block");
          $("#otpformdata").css("display", "none");
        }
      },
      error: function() {
        $("body").removeClass("loading");
        $("#mobilenumber").addClass("worng-error-otp");
        document.getElementById("errormsg").innerText = 'Something went wrong';
        $("#numberformdata").css("display", "block");
        $("#otpformdata").css("display", "none");
      },
    });
  });

  $(document.body).on('click', '.input-otp-valued', function() {
    $(".input-otp-valued").removeClass("worng-error-otp");
    $("#errormsg-otp").css("display", "none");
  });

  $(document.body).on('click', '#otpformbtn', function() {
    $("body").addClass("loading");
    $.ajax({
      url: "<?php echo $CFG->wwwroot; ?>/auth/otpbasedregandlogin/mobotpcheck.php",
      method: 'POST',
      data: {
        'mobilenumber' : $("input[name='custmobilenumber']").val(),
        'otp' : $("input[name='custotp1']").val()+$("input[name='custotp2']").val()+$("input[name='custotp3']").val()+$("input[name='custotp4']").val()+$("input[name='custotp5']").val()+$("input[name='custotp6']").val(),
      },
      success: function(json) {
        $("body").removeClass("loading");
        var data = $.parseJSON(json);
        if (data.status == 'error') {
          $(".input-otp-valued").addClass("worng-error-otp");
          document.getElementById("errormsg-otp").innerText = data.errormsg;
          $("#errormsg-otp").css("display", "block");
        } else if (data.status == 'success') {
          window.location.replace(data.returnurl);
        } else {
          $(".input-otp-valued").addClass("worng-error-otp");
          document.getElementById("errormsg").innerText = 'Something went wrong';
        }
      },
      error: function() {
        $("body").removeClass("loading");
        $(".input-otp-valued").addClass("worng-error-otp");
        document.getElementById("errormsg-otp").innerText = 'Something went wrong';
      },
    });
  });

  function validatenumber(evt) {
    var theEvent = evt || window.event;
    if (theEvent.type === 'paste') {
      key = event.clipboardData.getData('text/plain');
    } else {
      var key = theEvent.keyCode || theEvent.which;
      key = String.fromCharCode(key);
    }
    var regex = /[0-9]|\./;
    if( !regex.test(key) ) {
      theEvent.returnValue = false;
      if(theEvent.preventDefault) theEvent.preventDefault();
    }
  }

</script>