<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * OTP Login.
 *
 * @package   auth_otpbasedregandlogin
 * @copyright 2020 Digital Tricksters Software Solutions
 * @author    Trideep Das Modak <trideep@digital-tricksters.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(__DIR__ . '/../../config.php');

global $OUTPUT, $CFG, $PAGE, $DB;

require_once(__DIR__ . '/auth.php');
require_once($CFG->libdir.'/authlib.php');
require_once($CFG->dirroot.'/login/lib.php');
require_once($CFG->libdir.'/moodlelib.php');
require_once($CFG->dirroot.'/cohort/lib.php');
require_once($CFG->dirroot.'/group/lib.php');
require_once($CFG->dirroot.'/course/lib.php');
require_once($CFG->dirroot."/lib/enrollib.php");
require_once($CFG->dirroot."/auth/otpbasedregandlogin/country.php");
require_once($CFG->dirroot."/auth/otpbasedregandlogin/Twilio/autoload.php");


header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, PUT, OPTIONS, PATCH, DELETE');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Headers: Authorization, Content-Type, x-xsrf-token, x_csrftoken, Cache-Control, X-Requested-With');
use Twilio\Rest\Client;

if (empty($_POST['countrycode']) || empty($_POST['mobilenumber'])) {
	$output = array(
		'status' => 'error',
		'errormsg' => 'Enter your phone or mobile number'
	);
	echo json_encode($output);
	die;
} else {
	$countrycode = $_POST['countrycode'];
	$mobilenumber = $_POST['mobilenumber'];

	// Checking.
	if ($DB->record_exists('user', array('phone1' => $_POST['mobilenumber'], 'deleted' => 0))) {
		$user = $DB->get_record('user', array('phone1' => $_POST['mobilenumber'], 'deleted' => 0));
		if (!empty($user)) {
			$output = sendOTP($_POST['countrycode'], $_POST['mobilenumber']);
			echo json_encode($output);
			die;
		}
	} elseif ($DB->record_exists('user', array('phone2' => $_POST['mobilenumber'], 'deleted' => 0))) {
		$user = $DB->get_record('user', array('phone2' => $_POST['mobilenumber'], 'deleted' => 0));
		if (!empty($user)) {
			$output = sendOTP($_POST['countrycode'], $_POST['mobilenumber']);
			echo json_encode($output);
			die;
		}
	} else {
		$output = array(
			'status' => 'error',
			'errormsg' =>  'Mobile number not registered'
		);
		echo json_encode($output);
		die;
	}
}

function sendOTP($countryCode, $phoneNumber) {  
	try {  
		global $sid, $token, $from, $DB;
		$sid = get_config('auth_otpbasedregandlogin', 'otp_account_no');
		$token = get_config('auth_otpbasedregandlogin', 'otp_token_id');
		$from = get_config('auth_otpbasedregandlogin', 'otp_sender_no');
		$client = new Client($sid , $token);  
		$otp = rand(100000, 999999);
		// $otp = 123456;
		$message = $client->messages->create($countryCode . $phoneNumber,
			array("from" => $from, "body" => "Your One Time Password is " . $otp) 
		);
		$userlog = new stdClass();
		$userlog->phone_number = $phoneNumber;
		$userlog->otp = $otp;
		$userlog->auth_type_check = 'login';
		$DB->insert_record('auth_otpbasedregandlogin', $userlog);
		$output = array(
			'status' => 'success',
			'phonenumber' => $phoneNumber
		);
		return $output;
	} catch(\Exception $ex) {
		$output = array(
			'status' => 'error',
			'errormsg' =>  $ex->getMessage()
		);
		return $output;
	}  
}

die;