<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * OTP Login.
 *
 * @package   auth_otpbasedregandlogin
 * @copyright 2020 Digital Tricksters Software Solutions
 * @author    Trideep Das Modak <trideep@digital-tricksters.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(__DIR__ . '/../../config.php');

global $OUTPUT, $CFG, $PAGE, $DB;

require_once(__DIR__ . '/auth.php');
require_once($CFG->libdir.'/authlib.php');
require_once($CFG->dirroot.'/login/lib.php');
require_once($CFG->libdir.'/moodlelib.php');
require_once($CFG->dirroot.'/cohort/lib.php');
require_once($CFG->dirroot.'/group/lib.php');
require_once($CFG->dirroot.'/course/lib.php');
require_once($CFG->dirroot."/lib/enrollib.php");
require_once($CFG->dirroot."/auth/otpbasedregandlogin/country.php");
require_once($CFG->dirroot."/auth/otpbasedregandlogin/Twilio/autoload.php");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, PUT, OPTIONS, PATCH, DELETE');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Headers: Authorization, Content-Type, x-xsrf-token, x_csrftoken, Cache-Control, X-Requested-With');
use Twilio\Rest\Client;

$authplugin = get_auth_plugin('otpbasedregandlogin');

if (empty($_POST['mobilenumber']) || empty($_POST['otp'])) {
	$output = array(
		'status' => 'error',
		'errormsg' => 'Enter your OTP'
	);
	echo json_encode($output);
	die;
} else {
	if ($DB->record_exists('auth_otpbasedregandlogin', array('phone_number' => $_POST['mobilenumber'], 'otp' => $_POST['otp']))) {
		$otpbraldatas = $DB->get_records('auth_otpbasedregandlogin', array('phone_number' => $_POST['mobilenumber'], 'otp' => $_POST['otp']));
		foreach ($otpbraldatas as $key => $value) {
			$otpbraldata = $value;
		}
		if ($otpbraldata->auth_type_check == 'registration') {
			$DB->delete_records('auth_otpbasedregandlogin', array('phone_number' => $_POST['mobilenumber']));
			$output = array(
				'status' => 'success',
				'statusmsg' => 'Your mobile number is verified.',
			);
			echo json_encode($output);
			die;
		} else {
			if ($DB->record_exists('user', array('phone1' => $_POST['mobilenumber'], 'deleted' => 0))) {
				$user = $DB->get_record('user', array('phone1' => $_POST['mobilenumber'], 'deleted' => 0));
				if (!empty($user)) {
					$DB->delete_records('auth_otpbasedregandlogin', array('phone_number' => $_POST['mobilenumber']));
					if ($authplugin->user_login($user->username, $user->password)) {
						$user->loggedin = true;
						$user->site     = $CFG->wwwroot;
						complete_user_login($user);
						$output = array(
							'status' => 'success',
							'returnurl' => $CFG->wwwroot.'/my',
							'username' => $user->username,
							'password' => $DB->get_field('user_staging_table', 'password', ['username' => $user->username])

						);
						echo json_encode($output);
						die;
					}
				}
			} elseif ($DB->record_exists('user', array('phone2' => $_POST['mobilenumber'], 'deleted' => 0))) {
				$user = $DB->get_record('user', array('phone2' => $_POST['mobilenumber'], 'deleted' => 0));
				if (!empty($user)) {
					$DB->delete_records('auth_otpbasedregandlogin', array('phone_number' => $_POST['mobilenumber']));
					if ($authplugin->user_login($user->username, $user->password)) {
						$user->loggedin = true;
						$user->site     = $CFG->wwwroot;
						complete_user_login($user);
						$output = array(
							'status' => 'success',
							'returnurl' => $CFG->wwwroot.'/my',
							'username' => $user->username,
							'password' => $DB->get_field('user_staging_table', 'password', ['username' => $user->username])
						);
						echo json_encode($output);
						die;
					}
				}
			}
		}
		
	} else {
		$output = array(
			'status' => 'error',
			'errormsg' =>  'Wrong OTP entered'
		);
		echo json_encode($output);
		die;
	}
}
