<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * OTP Login.
 *
 * @package   auth_otpbasedregandlogin
 * @copyright 2020 Digital Tricksters Software Solutions
 * @author    Trideep Das Modak <trideep@digital-tricksters.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

if ($ADMIN->fulltree) {

    $settings->add(new admin_setting_heading('auth_otpbasedregandlogin_license', get_string('licensesettings', 'auth_otpbasedregandlogin'),
         get_string('licensesettings_desc', 'auth_otpbasedregandlogin')));

    $settings->add(new admin_setting_heading('auth_otpbasedregandlogin/registrationsettings', new lang_string('otpbasedregandloginregistrationsettings', 'auth_otpbasedregandlogin'),
        new lang_string('otpbasedregandlogindescription', 'auth_otpbasedregandlogin')));

    $options = array(
        new lang_string('no'),
        new lang_string('yes'),
    );

    $settings->add(new admin_setting_configselect('auth_otpbasedregandlogin/recaptcha',
        new lang_string('otpbasedregandloginrecaptcha_key', 'auth_otpbasedregandlogin'),
        new lang_string('otpbasedregandloginrecaptcha', 'auth_otpbasedregandlogin'), 0, $options));

    $settings->add(new admin_setting_heading('auth_otpbasedregandlogin/loginsettings', new lang_string('otpbasedregandloginloginsettings', 'auth_otpbasedregandlogin'), ''));

    $configkey = new lang_string('otp_opname', 'auth_otpbasedregandlogin');
    $configdesc = new lang_string('otp_opname_desc', 'auth_otpbasedregandlogin');
    $configdefault = new lang_string('otp_opname_default', 'auth_otpbasedregandlogin');
    $settings->add(new admin_setting_configtext('auth_otpbasedregandlogin/otp_opname', $configkey, $configdesc, $configdefault, PARAM_TEXT));

    $settings->add(new admin_setting_heading('auth_otpbasedregandlogin/twillosettings', 
        new lang_string('otpbasedregandlogintwillosettings', 'auth_otpbasedregandlogin'), ''));

    $configkey = new lang_string('otp_account_no', 'auth_otpbasedregandlogin');
    $configdesc = new lang_string('otp_account_no_desc', 'auth_otpbasedregandlogin');
    $configdefault = new lang_string('otp_account_no_default', 'auth_otpbasedregandlogin');
    $settings->add(new admin_setting_configtext('auth_otpbasedregandlogin/otp_account_no', $configkey, $configdesc, $configdefault, PARAM_TEXT));

    $configkey = new lang_string('otp_token_id', 'auth_otpbasedregandlogin');
    $configdesc = new lang_string('otp_token_id_desc', 'auth_otpbasedregandlogin');
    $configdefault = new lang_string('otp_token_id_default', 'auth_otpbasedregandlogin');
    $settings->add(new admin_setting_configtext('auth_otpbasedregandlogin/otp_token_id', $configkey, $configdesc, $configdefault, PARAM_TEXT));

    $configkey = new lang_string('otp_sender_no', 'auth_otpbasedregandlogin');
    $configdesc = new lang_string('otp_sender_no_desc', 'auth_otpbasedregandlogin');
    $configdefault = new lang_string('otp_sender_no_default', 'auth_otpbasedregandlogin');
    $settings->add(new admin_setting_configtext('auth_otpbasedregandlogin/otp_sender_no', $configkey, $configdesc, $configdefault, PARAM_TEXT));

}