<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Authentication Plugin: Online Self-registration
 * 
 * @author  Trideep Das Modak <trideep@dualcube.com>
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 * @package auth_otpbasedregandlogin
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir.'/formslib.php');
require_once($CFG->dirroot.'/user/profile/lib.php');
require_once($CFG->dirroot . '/user/editlib.php');
require_once('lib.php');

class login_signup_form extends moodleform implements renderable, templatable {
    function definition() {
        global $USER, $CFG, $DB;

        $mform = $this->_form;

        // registration header
        $mform->addElement('html', '<center><div class="qheader"> <h3> Create a new account </h3> </div></center> <br>');

        // username feild
        $mform->addElement('text', 'username', get_string('username'), 'maxlength="100" size="30"');
        $mform->setType('username', PARAM_RAW);
        $mform->addRule('username', 'Missing username', 'required', null, 'client');
        $mform->addHelpButton('username', 'username', 'auth_otpbasedregandlogin');

        // email feild
        $mform->addElement('text', 'email', get_string('email'), 'maxlength="100" size="30"');
        $mform->setType('email', core_user::get_property_type('email'));
        $mform->addRule('email', get_string('missingemail'), 'required', null, 'client');
        $mform->addHelpButton('email', 'email', 'auth_otpbasedregandlogin');
        $mform->setForceLtr('email');

        // password feild
        $mform->addElement('password', 'password', get_string('password'), 'maxlength="32" size="30"');
        $mform->setType('password', core_user::get_property_type('password'));
        $mform->addRule('password', get_string('missingpassword'), 'required', null, 'client');
        if (!empty($CFG->passwordpolicy)){
            //$mform->addElement('static', 'passwordpolicyinfo', '', '<strong>**</strong> '.print_password_policy());

            $mform->addHelpButton('password', 'password', 'auth_otpbasedregandlogin');
        }

        // firstname feild
        $mform->addElement('text', 'firstname', get_string('firstname'), 'maxlength="100" size="30"');
        $mform->setType('firstname', PARAM_RAW);
        $mform->addRule('firstname', 'Missing first name', 'required', null, 'client');
        $mform->addHelpButton('firstname', 'firstname', 'auth_otpbasedregandlogin');

        // lastname feild
        $mform->addElement('text', 'lastname', 'Last name', 'maxlength="100" size="30"');
        $mform->setType('lastname', PARAM_RAW);
        $mform->addRule('lastname', 'Missing last name', 'required', null, 'client');
        $mform->addHelpButton('lastname', 'lastname', 'auth_otpbasedregandlogin');



        //country feild
        $states  = array();
        
        $country = get_string_manager()->get_list_of_countries();
        $default_country[''] = get_string('selectacountry');
        $country = array_merge($default_country, $country);
        $mform->addElement('select', 'country', get_string('country'), $country,);
        $mform->addRule('country', 'Missing country', 'required', null, 'client');
        $mform->addHelpButton('country', 'country', 'auth_otpbasedregandlogin');
        if( !empty($CFG->country) ){
            $mform->setDefault('country', $CFG->country);
        }else{
            $mform->setDefault('country', '');
        }



        // // $states  = array();
        // // if(isset($_POST['country']) && !empty($_POST['country'])){
        //     // $country = $_POST['IN'];

        //     $state_list = $DB->get_records_sql("SELECT * FROM {state_list} where country_id = ?", array('IN'));
        //     foreach ($state_list as $state) {
        //         $states[$state->state_name] = $state->state_name;
        //     }
        // // }

        // $mform->addElement('select', 'state', 'State', $states);
        // if(!empty($_POST['state'])){
        //     $mform->setDefault('state', $_POST['state']);
        // } else {
        //     $mform->setDefault('state', $_POST['state']);
        // }


        $states  = array();
        $country = 'IN';
        if(isset($_POST['country']) && !empty($_POST['country'])){
            $country = $_POST['country'];
        }
        $state_list = $DB->get_records_sql("SELECT * FROM {state_list} where country_id = ?", array($country));
        foreach ($state_list as $state) {
            $states[$state->state_name] = $state->state_name;
        }

        $mform->addElement('select', 'state', 'State', $states);
        if(!empty($_POST['state'])){
            $mform->setDefault('state', $_POST['state']);
        } else {
            $mform->setDefault('state', $_POST['state']);
        }




        // city feild
        $mform->addElement('text', 'city', get_string('city'), 'maxlength="120" size="30"');
        $mform->setType('city', core_user::get_property_type('city'));
        if (!empty($CFG->defaultcity)) {
            $mform->setDefault('city', $CFG->defaultcity);
        }
        $mform->addRule('city', 'Missing city', 'required', null, 'client');
        $mform->addHelpButton('city', 'city', 'auth_otpbasedregandlogin');


        // phone2 feild
        $mform->addElement('text', 'phone2', 'Mobile no', 'maxlength="15" size="30"');
        $mform->setType('phone2', PARAM_INT);
        $mform->addRule('phone2', 'Missing mobile no', 'required', null, 'client');
        $mform->addHelpButton('phone2', 'phone2', 'auth_otpbasedregandlogin');

        // otpverified feild
        $mform->addElement('hidden', 'otpverified', 0);
        $mform->setType('otpverified', PARAM_INT);

        profile_signup_fields($mform);

        if (signup_captcha_enabled()) {
            $mform->addElement('recaptcha', 'recaptcha_element', get_string('security_question', 'auth'));
            $mform->addHelpButton('recaptcha_element', 'recaptcha', 'auth');
            $mform->closeHeaderBefore('recaptcha_element');
        }

        // Hook for plugins to extend form definition.
        core_login_extend_signup_form($mform);

        // Add "Agree to sitepolicy" controls. By default it is a link to the policy text and a checkbox but
        // it can be implemented differently in custom sitepolicy handlers.
        $manager = new \core_privacy\local\sitepolicy\manager();
        $manager->signup_form($mform);

        // buttons
        $this->add_action_buttons(true, 'Register');

    }

    function definition_after_data(){
        $mform = $this->_form;
        $mform->applyFilter('username', 'trim');

        // Trim required name fields.
        foreach (useredit_get_required_name_fields() as $field) {
            $mform->applyFilter($field, 'trim');
        }
    }

    function signup_validate_data($data, $files) {
        global $CFG, $DB;

        $errors = array();
        $authplugin = get_auth_plugin($CFG->registerauth);

        if ($DB->record_exists('user', array('username' => $data['username'], 'mnethostid' => $CFG->mnet_localhost_id))) {
            $errors['username'] = get_string('usernameexists');
        } else {
            // Check allowed characters.
            if ($data['username'] !== core_text::strtolower($data['username'])) {
                $errors['username'] = 'Username must in lowercase';
            } else {
                if ($data['username'] !== core_user::clean_field($data['username'], 'username')) {
                    $errors['username'] = 'Invalid username, choose another';
                }

            }
        }
        if ($authplugin->user_exists($data['username'])) {
            $errors['username'] = 'Username already exists.';
        }

        // Check if user exists in external db.
        // TODO: maybe we should check all enabled plugins instead.
        if ($authplugin->user_exists($data['email'])) {
            $errors['email'] = 'User email already exists.';
        }

        if (! validate_email($data['email'])) {
            $errors['email'] = get_string('invalidemail');

        } else if (empty($CFG->allowaccountssameemail)) {
            // Make a case-insensitive query for the given email address.
            $select = $DB->sql_equal('email', ':email', false) . ' AND mnethostid = :mnethostid';
            $params = array(
                'email' => $data['email'],
                'mnethostid' => $CFG->mnet_localhost_id,
            );
            // If there are other user(s) that already have the same email, show an error.
            if ($DB->record_exists_select('user', $select, $params)) {
                $forgotpasswordurl = new moodle_url('/login/forgot_password.php');
                $forgotpasswordlink = html_writer::link($forgotpasswordurl, get_string('emailexistshintlink'));
                $errors['email'] = get_string('emailexists') . ' ' . get_string('emailexistssignuphint', 'moodle', $forgotpasswordlink);
            }
        }

        if (!isset($errors['email'])) {
            if ($err = email_is_not_allowed($data['email'])) {
                $errors['email'] = $err;
            }
        }

        if (empty($data['phone2'])) {
            $errors['phone2'] = 'Missing mobile no';
        } else {
            if ($DB->record_exists('user', array('phone1' => $data['phone2'], 'mnethostid' => $CFG->mnet_localhost_id, 'deleted' => 0))) {
                $errors['phone2'] = 'Mobile no exists';
            } elseif ($DB->record_exists('user', array('phone2' => $data['phone2'], 'mnethostid' => $CFG->mnet_localhost_id, 'deleted' => 0))) {
                $errors['phone2'] = 'Mobile no exists';
            }
        }
        if (!is_int($data['phone2'])) {
            $errors['phone2'] = 'Invalid mobile no';
        }

        if (empty($errors['phone2'])) {
            if (empty($data['otpverified']) || $data['otpverified'] == 0) {
                $errors['phone2'] = 'Verify your mobile no';
            }
        }

        // Construct fake user object to check password policy against required information.
        $tempuser = new stdClass();
        $tempuser->id = 1;
        $tempuser->username = $data['username'];
        $tempuser->firstname = $data['firstname'];
        $tempuser->lastname = $data['lastname'];
        $tempuser->email = $data['email'];

        $errmsg = '';
        if (!check_password_policy($data['password'], $errmsg, $tempuser)) {
            $errors['password'] = $errmsg;
        }

        // Validate customisable profile fields. (profile_validation expects an object as the parameter with userid set).
        $dataobject = (object)$data;
        $dataobject->id = 0;
        $errors += profile_validation($dataobject, $files);

        return $errors;
    }

    /**
     * Validate user supplied data on the signup form.
     *
     * @param array $data array of ("fieldname"=>value) of submitted data
     * @param array $files array of uploaded files "element_name"=>tmp_file_path
     * @return array of "element_name"=>"error_description" if there are errors,
     *         or an empty array if everything is OK (true allowed for backwards compatibility too).
     */
    public function validation($data, $files) {
        $errors = parent::validation($data, $files);

        // Extend validation for any form extensions from plugins.
        $errors = array_merge($errors, core_login_validate_extend_signup_form($data));

        if (signup_captcha_enabled()) {
            $recaptchaelement = $this->_form->getElement('recaptcha_element');
            if (!empty($this->_form->_submitValues['g-recaptcha-response'])) {
                $response = $this->_form->_submitValues['g-recaptcha-response'];
                if (!$recaptchaelement->verify($response)) {
                    $errors['recaptcha_element'] = get_string('incorrectpleasetryagain', 'auth');
                }
            } else {
                $errors['recaptcha_element'] = get_string('missingrecaptchachallengefield');
            }
        }


        $errors += $this->signup_validate_data($data, $files);

        return $errors;
    }

    /**
     * Export this data so it can be used as the context for a mustache template.
     *
     * @param renderer_base $output Used to do a final render of any components that need to be rendered for export.
     * @return array
     */
    public function export_for_template(renderer_base $output) {
        ob_start();
        $this->display();
        $formhtml = ob_get_contents();
        ob_end_clean();
        $context = [
            'formhtml' => $formhtml
        ];
        return $context;
    }
}
?>

<style type="text/css">
#page-login-signup div#page {
    background-image: url(<?php echo $CFG->wwwroot?>/auth/otpbasedregandlogin/pix/otp-login-bg.jpg);
}
</style>

<script src="<?php echo $CFG->wwwroot; ?>/auth/otpbasedregandlogin/js/jquerycdn.min.js"></script>
<script type="text/javascript">
    $(document).ready(function(){

        // check mobile number already verivied or not
        if ($('input[name="otpverified"]').val() == 1) {
            $("#regverifyotptxt").removeClass("worng-error-otp");
            $("#errormsg").css("display", "none");
            $("#regsubotpdiv").css("display", "none");
            $("#regotpverifieddiv").css("display", "block");
            if($("#regotpverifieddiv").length == 0) {
                $("div#fitem_id_phone2").append("<div class='col-md-12' id='regotpverifieddiv'><span id='otpverifiedspan'><image id='otpverifiedimg' src='<?php echo $CFG->wwwroot; ?>/auth/otpbasedregandlogin/pix/otpverified.png'>Your mobile number is verified.</span></div><div class='modal'></div>");
            } else {
                $("#regotpverifieddiv").css("display", "block");
            }
        }

        // check otpbtn visible or not
        if ($("#id_phone2").hasClass("is-invalid")) {
            if ($('#id_error_phone2').text().indexOf('Verify your mobile no') != -1) {
                if($("#regotpdiv").length == 0) {
                    $("div#fitem_id_phone2").append("<div class='col-md-12' id='regotpdiv'><button id='regotpbtn' type='button'>Send OTP</button></div><div class='modal'></div>");
                } else {
                    $("#regotpdiv").css("display", "block");
                }
            }
        }

        $(document.body).on('keyup', '#id_phone2', function() {
            $('input[name="otpverified"]').val(0);
            $("#regotpdiv").css("display", "block");
            $("#regsubotpdiv").css("display", "none");
            $("#regotpverifieddiv").css("display", "none");
            this.value = this.value.replace(/[^0-9\.]/g,'');
            var phone2 = $('#id_phone2').val();
            var id_country = $('#id_country option:selected').val();
            if( !phone2.length == 0 && !id_country.length == 0 ) {
                if($("#regotpbtn").length == 0) {
                    $("div#fitem_id_phone2").append("<div class='col-md-12' id='regotpdiv'><button id='regotpbtn' type='button'>Send OTP</button></div><div class='modal'></div>");
                } else {
                    $("#regotpdiv").css("display", "block");

                }
            }
        });

        $(document.body).on('click', '#id_country', function() {
            $('input[name="otpverified"]').val(0);
            $("#regotpdiv").css("display", "block");
            $("#regsubotpdiv").css("display", "none");
            $("#regotpverifieddiv").css("display", "none");
            var phone2 = $('#id_phone2').val();
            var id_country = $('#id_country option:selected').val();
            if( !phone2.length == 0 && !id_country.length == 0 ) {
               if($("#regotpbtn").length == 0) {
                    $("div#fitem_id_phone2").append("<div class='col-md-12' id='regotpdiv'><button id='regotpbtn' type='button'>Send OTP</button></div><div class='modal'></div>");
                } else {
                    $("#regotpdiv").css("display", "block");

                }
            }
        });

        // OTP send ajax form. 
        $(document.body).on('click', '#regotpbtn', function() {
            $("body").addClass("loading");
            var id_country = $("#id_country option:selected").val();
            $.ajax({
                url: "<?php echo $CFG->wwwroot; ?>/auth/otpbasedregandlogin/mobregcheck.php",
                method: 'POST',
                data: {
                    'countrycode' : $("#id_country option:selected").val(),
                    'mobilenumber' : $("#id_phone2").val(),
                },
                success: function(json) {
                    $("body").removeClass("loading");
                    var data = $.parseJSON(json);
                    if (data.status == 'error') {
                        if(data.errormsg.indexOf('[HTTP 400] Unable to create record: The \'To\' number') != -1){
                            $("#id_phone2").removeClass("is-invalid");
                            $("#id_error_phone2").css("display", "none");
                            $("#id_error_country").css("display", "block");
                            $("#id_country").addClass("is-invalid");
                            document.getElementById("id_error_country").innerText = '[HTTP 400] Unable to create record: The country you selected is not a valid country for your phone number.';
                        } else {
                            $("#id_country").removeClass("is-invalid");
                            $("#id_error_country").css("display", "none");
                            $("#id_error_phone2").css("display", "block");
                            $("#id_phone2").addClass("is-invalid");
                            document.getElementById("id_error_phone2").innerText = data.errormsg;
                        }
                    } else if (data.status == 'success') {
                        $("#id_phone2").removeClass("is-invalid");
                            $("#id_error_phone2").css("display", "none");
                        $("#id_country").removeClass("is-invalid");
                        $("#id_error_country").css("display", "none");
                        $("#regotpdiv").css("display", "none");
                        if($("#regsubotpdiv").length == 0) {
                            $("div#fitem_id_phone2").append("<div class='col-md-12' id='regsubotpdiv'><div class='col-md-4'><button id='regresendotpbtn' type='button'>Resend OTP</button></div><div class='col-md-5'><input type='text' id='regverifyotptxt' placeholder='Enter OTP' maxlength=6></div><div class='col-md-3'><button id='regverifyotpbtn' type='button'>Verify OTP</button></div></div><span id='errormsg' class='Entered-worng-otp-cls' style='display: none;'></span>");
                        } else {
                            $("#regsubotpdiv").css("display", "-webkit-inline-box");

                        }
                            $('#regverifyotptxt').focus();
                    } else {
                        $("#id_error_country").css("display", "block");
                        $("#id_country").addClass("is-invalid");
                        document.getElementById("id_error_country").innerText = 'Something went wrong. Please make sure that you selected a valid country.';
                        $("#id_error_phone2").css("display", "block");
                        $("#id_phone2").addClass("is-invalid");
                        document.getElementById("id_error_phone2").innerText = 'Something went wrong. Please make sure that you entered a valid mobile number.';
                    }
                },
                error: function() {
                    $("body").removeClass("loading");
                    $("#id_error_country").css("display", "block");
                    $("#id_country").addClass("is-invalid");
                    document.getElementById("id_error_country").innerText = 'Something went wrong. Please make sure that you selected a valid country.';
                    $("#id_error_phone2").css("display", "block");
                    $("#id_phone2").addClass("is-invalid");
                    document.getElementById("id_error_phone2").innerText = 'Something went wrong. Please make sure that you entered a valid mobile number.';
                },
            });
        });

        // OTP resend ajax form.
        $(document.body).on('click', '#regresendotpbtn', function() {
            $("body").addClass("loading");
            var id_country = $("#id_country option:selected").val();
            $.ajax({
                url: "<?php echo $CFG->wwwroot; ?>/auth/otpbasedregandlogin/mobregcheck.php",
                method: 'POST',
                data: {
                    'countrycode' : $("#id_country option:selected").val(),
                    'mobilenumber' : $("#id_phone2").val(),
                },
                success: function(json) {
                    $("body").removeClass("loading");
                    var data = $.parseJSON(json);
                    if (data.status == 'error') {
                        if(data.errormsg.indexOf('[HTTP 400] Unable to create record: The \'To\' number') != -1){
                            $("#id_phone2").removeClass("is-invalid");
                            $("#id_error_phone2").css("display", "none");
                            $("#id_error_country").css("display", "block");
                            $("#id_country").addClass("is-invalid");
                            document.getElementById("id_error_country").innerText = '[HTTP 400] Unable to create record: The country you selected is not a valid country for your phone number.';
                        } else {
                            $("#id_country").removeClass("is-invalid");
                            $("#id_error_country").css("display", "none");
                            $("#id_error_phone2").css("display", "block");
                            $("#id_phone2").addClass("is-invalid");
                            document.getElementById("id_error_phone2").innerText = data.errormsg;
                        }
                    } else if (data.status == 'success') {
                        $("#id_phone2").removeClass("is-invalid");
                            $("#id_error_phone2").css("display", "none");
                        $("#id_country").removeClass("is-invalid");
                        $("#id_error_country").css("display", "none");
                        $("#regotpdiv").css("display", "none");
                        $('#regverifyotptxt').focus();
                    } else {
                        $("#id_error_country").css("display", "block");
                        $("#id_country").addClass("is-invalid");
                        document.getElementById("id_error_country").innerText = 'Something went wrong. Please make sure that you selected a valid country.';
                        $("#id_error_phone2").css("display", "block");
                        $("#id_phone2").addClass("is-invalid");
                        document.getElementById("id_error_phone2").innerText = 'Something went wrong. Please make sure that you entered a valid mobile number.';
                    }
                },
                error: function() {
                    $("body").removeClass("loading");
                    $("#id_error_country").css("display", "block");
                    $("#id_country").addClass("is-invalid");
                    document.getElementById("id_error_country").innerText = 'Something went wrong. Please make sure that you selected a valid country.';
                    $("#id_error_phone2").css("display", "block");
                    $("#id_phone2").addClass("is-invalid");
                    document.getElementById("id_error_phone2").innerText = 'Something went wrong. Please make sure that you entered a valid mobile number.';
                },
            });
        });

        // OTP check ajax form.
        $(document.body).on('click', '#regverifyotpbtn', function() {
            $("body").addClass("loading");
            $.ajax({
                url: "<?php echo $CFG->wwwroot; ?>/auth/otpbasedregandlogin/mobotpcheck.php",
                method: 'POST',
                data: {
                    'mobilenumber' : $("#id_phone2").val(),
                    'otp' : $("#regverifyotptxt").val(),
                },
                success: function(json) {
                    $("body").removeClass("loading");
                    var data = $.parseJSON(json);
                    if (data.status == 'error') {
                        $("#regverifyotptxt").addClass("worng-error-otp");
                        document.getElementById("errormsg").innerText = data.errormsg;
                        $("#errormsg").css("display", "block");
                        $('#regverifyotptxt').focus();
                    } else if (data.status == 'success') {
                        $('input[name="otpverified"]').val(1);
                        $("#regverifyotptxt").removeClass("worng-error-otp");
                        $("#errormsg").css("display", "none");
                        $("#regsubotpdiv").css("display", "none");
                        $("#regotpverifieddiv").css("display", "block");
                        if($("#regotpverifieddiv").length == 0) {
                            $("div#fitem_id_phone2").append("<div class='col-md-12' id='regotpverifieddiv''><span id='otpverifiedspan'><image id='otpverifiedimg' src='<?php echo $CFG->wwwroot; ?>/auth/otpbasedregandlogin/pix/otpverified.png'>"+data.statusmsg+"</span></div><div class='modal'></div>");
                        } else {
                            $("#regotpverifieddiv").css("display", "block");

                        }
                    } else {
                        $("#regverifyotptxt").addClass("worng-error-otp");
                        document.getElementById("errormsg").innerText = data.errormsg;
                        $("#errormsg").css("display", "block");
                        $('#regverifyotptxt').focus();
                    }
                },
                error: function() {
                    $("body").removeClass("loading");
                    $("#regverifyotptxt").addClass("worng-error-otp");
                    document.getElementById("errormsg").innerText = 'Something went wrong. Please try again later.';
                    $("#errormsg").css("display", "block");
                    $('#regverifyotptxt').focus();
                },
            });
        });

        $(document.body).on('keyup', '#regverifyotptxt', function() {
            this.value = this.value.replace(/[^0-9\.]/g,'');
        });

        function validatenumber(evt) {
            var theEvent = evt || window.event;
            if (theEvent.type === 'paste') {
                key = event.clipboardData.getData('text/plain');
            } else {
                var key = theEvent.keyCode || theEvent.which;
                key = String.fromCharCode(key);
            }
            var regex = /[0-9]|\./;
            if( !regex.test(key) ) {
                theEvent.returnValue = false;
                if(theEvent.preventDefault) theEvent.preventDefault();
            }
        }

    });

    $(document).ready(function(){
        $('#id_profile_field_learner_category').on('change',function(){
            var role = $(this).val();
            if(role == 'Industry​') {
                $(".industry​").show();   
                $(".state_fda").hide();   
                $(".academia​").hide();   
                $(".others​").hide();   
            } else if (role == 'State FDA/FSSAI​') {
                $(".state_fda").show();   
                $(".industry​").hide();   
                $(".academia​").hide();   
                $(".others​").hide();   
            } else if (role == 'Academia​') {
                $(".academia​").show();                
                $(".state_fda").hide();                
                $(".industry​").hide();                
                $(".others​").hide();   
            } else if (role == 'Others​') {
                $(".others​").show();   
                $(".academia​").hide();                
                $(".state_fda").hide();                
                $(".industry​").hide();                
            } else {
                $(".academia​").hide();                
                $(".state_fda").hide();                
                $(".industry​").hide();                
                $(".others​").hide();                
            }

        });
    });
    
</script>