/**
 * Populates or de-populates password field based on whether the
 * password is required or not.
 *
 * @copyright  2018 UC Regents
 * @author     Kubilay Agi
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_zoom/form",["jquery","core/form-autocomplete","core/str","core/notification"],(function($,autocomplete,str,notification){var SELECTORS_REPEAT_SELECT='select[name="recurrence_type"]',SELECTORS_REPEAT_INTERVAL=".repeat_interval",SELECTORS_REPEAT_INTERVAL_DAILY="#interval_daily",SELECTORS_REPEAT_INTERVAL_WEEKLY="#interval_weekly",SELECTORS_REPEAT_INTERVAL_MONTHLY="#interval_monthly",SELECTORS_REPEAT_INTERVAL_OPTIONS='select[name="repeat_interval"] option',SELECTORS_START_TIME='select[name*="start_time"]',SELECTORS_DURATION='*[name*="duration"]',SELECTORS_RECURRING='input[name="recurring"][type!="hidden"]',SELECTORS_OPTION_JBH='input[name="option_jbh"][type!="hidden"]',SELECTORS_OPTION_WAITING_ROOM='input[name="option_waiting_room"][type!="hidden"]',REPEAT_OPTIONS_REPEAT_OPTION_NONE=0,REPEAT_OPTIONS_REPEAT_OPTION_DAILY=1,REPEAT_OPTIONS_REPEAT_OPTION_WEEKLY=2,REPEAT_OPTIONS_REPEAT_OPTION_MONTHLY=3,REPEAT_MAX_OPTIONS_REPEAT_OPTION_WEEKLY=12,REPEAT_MAX_OPTIONS_REPEAT_OPTION_MONTHLY=3,toggleStartTimeDuration=function(){var disabled=!1,repeatVal=parseInt($(SELECTORS_REPEAT_SELECT).val(),10);$(SELECTORS_RECURRING).prop("checked")&&repeatVal===REPEAT_OPTIONS_REPEAT_OPTION_NONE&&(disabled=!0),$(SELECTORS_START_TIME).prop("disabled",disabled),$(SELECTORS_DURATION).prop("disabled",disabled)},toggleRepeatIntervalText=function(){$(SELECTORS_REPEAT_INTERVAL).hide();var repeatSelectVal=parseInt($(SELECTORS_REPEAT_SELECT).val(),10);repeatSelectVal===REPEAT_OPTIONS_REPEAT_OPTION_DAILY?$(SELECTORS_REPEAT_INTERVAL_DAILY).show():repeatSelectVal===REPEAT_OPTIONS_REPEAT_OPTION_WEEKLY?$(SELECTORS_REPEAT_INTERVAL_WEEKLY).show():repeatSelectVal===REPEAT_OPTIONS_REPEAT_OPTION_MONTHLY&&$(SELECTORS_REPEAT_INTERVAL_MONTHLY).show()},limitRepeatValues=function(){var selectedValue=parseInt($(SELECTORS_REPEAT_SELECT).val(),10);$(SELECTORS_REPEAT_INTERVAL_OPTIONS).each((function(){selectedValue===REPEAT_OPTIONS_REPEAT_OPTION_WEEKLY?this.value>REPEAT_MAX_OPTIONS_REPEAT_OPTION_WEEKLY&&$(this).hide():selectedValue===REPEAT_OPTIONS_REPEAT_OPTION_MONTHLY?this.value>REPEAT_MAX_OPTIONS_REPEAT_OPTION_MONTHLY&&$(this).hide():$(this).show()}))},TabsComponent=function(tabsColumn,tabsContentColumn,initialTabsCount,emptyAlert){this.tabsColumn=tabsColumn,this.tabsContentColumn=tabsContentColumn,this.emptyAlert=emptyAlert,this.countTabs=initialTabsCount,this.buildTab=function(item){var tab=item.tab.element,tabLink=$(".nav-link",tab);return tab.attr("id","tab-"+this.countTabs),$(".tab-name",tabLink).text(item.tab.name),tabLink.attr("href","#link"+this.countTabs),$("li a",this.tabsColumn).removeClass("active"),tabLink.addClass("active"),tab},this.buildTabContent=function(item){var tabContent=item.tabContent.element;return tabContent.attr("id","link"+this.countTabs),$(".tab-pane",this.tabsContentColumn).removeClass("active"),tabContent.addClass("active"),tabContent},this.addTab=function(item){var tab=this.buildTab(item),tabContent=this.buildTabContent(item);return this.emptyAlert.addClass("hidden"),$("ul",this.tabsColumn).append(tab),$(".tab-content",this.tabsContentColumn).append(tabContent),{element:tab,content:tabContent}},this.deleteTab=function(item){var tab=item,tabContent=$($("a",tab).attr("href"));(tab.remove(),tabContent.remove(),$("li",this.tabsColumn).length)?$("li a.active",this.tabsColumn).length||$("li:first-child a",this.tabsColumn).trigger("click"):this.emptyAlert.removeClass("hidden")}},BreakoutroomsEditor=function(){this.roomsListColumn=$("#meeting-rooms-list"),this.roomsList=$("ul",this.roomsListColumn),this.addBtn=$("#add-room",this.roomsListColumn),this.emptyAlert=$(".empty-alert",this.roomsListColumn),this.deleteBtn=$(".delete-room",this.roomsListColumn),this.roomsDataColumn=$("#meeting-rooms-data"),this.roomItemToClone=$("#rooms-list-item").html(),this.roomItemDataToClone=$("#rooms-list-item-data").html(),this.initialRoomsCount=parseInt(this.roomsListColumn.attr("data-initial-rooms-count")),this.tabsComponent=new TabsComponent(this.roomsListColumn,this.roomsDataColumn,this.initialRoomsCount,this.emptyAlert),this.init=function(){str.get_strings([{key:"room",component:"zoom"}]).then().fail(notification.exception),this.addRoomEvent(),this.deleteRoomEvent(),$("li",this.roomsListColumn).length?(this.changeRoomNameEvent(),this.buildAutocompleteComponents()):this.emptyAlert.removeClass("hidden")},this.addRoomEvent=function(){var thisObject=this;thisObject.addBtn.click((function(){thisObject.tabsComponent.countTabs++;var newRoomName=M.util.get_string("room","zoom")+" "+thisObject.tabsComponent.countTabs,newRoomElement=$(thisObject.roomItemToClone),newRoomDataElement=$(thisObject.roomItemDataToClone),newRoomIndex=thisObject.tabsComponent.countTabs,roomNameInputId="room-name-"+newRoomIndex;$("input[type=text]",newRoomDataElement).prev().attr("for",roomNameInputId),$("input[type=text]",newRoomDataElement).attr("id",roomNameInputId),$("input[type=text]",newRoomDataElement).attr("name",roomNameInputId),$("input[type=text]",newRoomDataElement).val(newRoomName),$("input[type=text]",newRoomDataElement).next().attr("name","rooms["+newRoomIndex+"]"),$("input[type=text]",newRoomDataElement).next().val(newRoomName);var roomParticipantsSelectId="participants-"+newRoomIndex;$(".room-participants",newRoomDataElement).attr("id",roomParticipantsSelectId),$(".room-participants",newRoomDataElement).attr("name","roomsparticipants["+newRoomIndex+"][]");var roomGroupsSelectId="groups-"+newRoomIndex;$(".room-groups",newRoomDataElement).attr("id",roomGroupsSelectId),$(".room-groups",newRoomDataElement).attr("name","roomsgroups["+newRoomIndex+"][]");var newRoom={tab:{name:newRoomName,element:newRoomElement},tabContent:{element:newRoomDataElement}},addedTab=thisObject.tabsComponent.addTab(newRoom);$("li:last .delete-room",thisObject.roomsList).click((function(){var thisItem=$(this).closest("li");thisObject.tabsComponent.deleteTab(thisItem)})),$("input[type=text]",addedTab.content).on("change keyup paste",(function(){var newHiddenValue=this.value;$(this).next().val(newHiddenValue),$(".tab-name",addedTab.element).text(this.value)})),thisObject.buildAutocompleteComponent(roomParticipantsSelectId,"addparticipant"),thisObject.buildAutocompleteComponent(roomGroupsSelectId,"addparticipantgroup")}))},this.deleteRoomEvent=function(){var thisObject=this;thisObject.deleteBtn.click((function(){var thisItem=$(this).closest("li");thisObject.tabsComponent.deleteTab(thisItem)}))},this.changeRoomNameEvent=function(){var thisObject=this;$("li",this.roomsListColumn).each((function(){var tabIndex=$(this).attr("id").split("-")[1];$('input[name="room-name-'+tabIndex+'"]',thisObject.roomsDataColumn).on("change keyup paste",(function(){var newHiddenValue=this.value;$(this).next().val(newHiddenValue),$("#tab-"+tabIndex+" .tab-name").text(this.value)}))}))},this.buildAutocompleteComponents=function(){var thisObject=this;$(".room-participants",thisObject.roomsDataColumn).each((function(){var thisItemId=$(this).attr("id");thisObject.buildAutocompleteComponent(thisItemId,"addparticipant")})),$(".room-groups",thisObject.roomsDataColumn).each((function(){var thisItemId=$(this).attr("id");thisObject.buildAutocompleteComponent(thisItemId,"addparticipantgroup")}))},this.buildAutocompleteComponent=function(id,placeholder){var stringkeys=[{key:placeholder,component:"zoom"},{key:"selectionarea",component:"zoom"}];str.get_strings(stringkeys).then((function(langstrings){var placeholderString=langstrings[0],noSelectionString=langstrings[1];return autocomplete.enhance("#"+id,!1,"",placeholderString,!1,!0,noSelectionString,!0),null})).fail(notification.exception)}};return{init:function(){var optionJoinBeforeHost=$(SELECTORS_OPTION_JBH),optionWaitingRoom=$(SELECTORS_OPTION_WAITING_ROOM);optionJoinBeforeHost.change((function(){!0===optionJoinBeforeHost.is(":checked")&&optionWaitingRoom.prop("checked",!1)})),optionWaitingRoom.change((function(){!0===optionWaitingRoom.is(":checked")&&optionJoinBeforeHost.prop("checked",!1)})),toggleStartTimeDuration(),toggleRepeatIntervalText(),limitRepeatValues(),$(SELECTORS_REPEAT_SELECT).change((function(){toggleStartTimeDuration(),toggleRepeatIntervalText(),limitRepeatValues()})),$(SELECTORS_RECURRING).change((function(){toggleStartTimeDuration()})),(new BreakoutroomsEditor).init()}}}));

//# sourceMappingURL=form.min.js.map