<?php
require_once('../config.php');
global $USER, $DB, $OUTPUT, $CFG;
require_login();

$title = 'Admin Dashboard';
$pagetitle = $title;
$PAGE->set_title($title);
$PAGE->set_heading($title);
$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_pagelayout('standard');

// User Picture
$context = context_user::instance($USER->id);
$file_path = $USER->picture;
$user_picture_url = moodle_url::make_pluginfile_url(
  $context->id,
  'user',
  'icon',
  null,
  '/',
  $file_path
);
$picture_notfound_url = "https://static.vecteezy.com/system/resources/previews/000/439/863/original/vector-users-icon.jpg";
$user_picture_url = $file_path ? $user_picture_url : $picture_notfound_url;

// Role of User
$managerroleid = $DB->get_field('role', 'id', ['shortname' => 'manager']);
$coursecreatorroleid = $DB->get_field('role', 'id', ['shortname' => 'coursecreator']);
$editingteacherroleid = $DB->get_field('role', 'id', ['shortname' => 'editingteacher']);
$teacherroleid = $DB->get_field('role', 'id', ['shortname' => 'teacher']);
$studentroleid = $DB->get_field('role', 'id', ['shortname' => 'student']);
$is_student = false;
if (is_siteadmin()) {
  $user_role = get_string('role_admin', 'local_runningbatch');
} else if (user_has_role_assignment($USER->id, $managerroleid)) {
  $user_role = get_string('role_manager', 'local_runningbatch');
} else if (user_has_role_assignment($USER->id, $coursecreatorroleid)) {
  $user_role = get_string('role_coursecreator', 'local_runningbatch');
} else if (user_has_role_assignment($USER->id, $editingteacherroleid)) {
  $user_role = get_string('role_editingteacher', 'local_runningbatch');
} else if (user_has_role_assignment($USER->id, $teacherroleid)) {
  $user_role = get_string('role_teacher', 'local_runningbatch');
} else if (user_has_role_assignment($USER->id, $studentroleid)) {
  $user_role = get_string('role_student', 'local_runningbatch');
  $is_student = true;
}

//////////////////////////////////////////////COURSE COMPLETION//////////////////////////////////////////////
$sql = "SELECT * FROM {course} WHERE format='topics'";
$courses = $DB->get_records_sql($sql);
$courseProgressArray = array();
$sno = 0;
foreach ($courses as $course) {
  $course_completion = \core_completion\progress::get_course_progress_percentage($course);
  $context = context_course::instance($course->id);
  $users = get_enrolled_users($context);
  $student_count = 0;
  $sno++;
  $students = get_role_users($studentroleid, $context, false, 'u.id, u.username, u.firstname, u.lastname, u.email', null, false);
  $student_count = count($students);
  $obj = new stdClass();
  $obj->courseName = $course->fullname;
  $obj->progress = $course_completion;
  $obj->student_count = $student_count;
  $obj->courseId = $course->id;
  $obj->sno = $sno;
  $courseProgressArray[] = $obj;
}
//////////////////////////////////////////////COURSE COMPLETION END//////////////////////////////////////////////

// Get last seven days record.
$todaydate = strtotime(date('y-m-d', time()));
$now = time();
$previousdate = strtotime('-6 days', $todaydate);

$sevendaysrecord = $DB->get_records_sql("SELECT * FROM {logstore_standard_log} WHERE action = 'loggedin' AND timecreated BETWEEN $previousdate AND $now");
foreach ($sevendaysrecord as $value) {
  $day = date('l', $value->timecreated);
  if ($day == 'Sunday') {
    $sun[] = $value->userid;
  }
  if ($day == 'Monday') {
    $mon[] = $value->userid;
  }
  if ($day == 'Tuesday') {
    $tues[] = $value->userid;
  }
  if ($day == 'Wednesday') {
    $wed[] = $value->userid;
  }
  if ($day == 'Thursday') {
    $thurs[] = $value->userid;
  }
  if ($day == 'Friday') {
    $fri[] = $value->userid;
  }
  if ($day == 'Saturday') {
    $sat[] = $value->userid;
  }
}
$useractivity = [count(array_unique($mon)), count(array_unique($tues)), count(array_unique($wed)), count(array_unique($thurs)), count(array_unique($fri)), count(array_unique($sat)), count(array_unique($sun))];
$useractivity = implode(",", $useractivity);

$templatecontext = [
  'is_admin' => is_siteadmin(),
  'is_student' => $is_student,
  'userfirstname' => $USER->firstname,
  'userlastname' => $USER->lastname,
  'user_picture' => $user_picture_url,
  'user_role' => $user_role,
  'db' => $DB,
  'courseProgressArray' => $courseProgressArray,
  'useractivity' => $useractivity
];

echo $OUTPUT->header();
echo $OUTPUT->render_from_template('local_dashboard_main/admin_dashboard', $templatecontext);
echo $OUTPUT->footer();
