<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Contains class plagiarism_similarity_setup_form
 *
 * @package   plagiarism_similarity
 * @copyright 2017 Dan Marsden
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * Class lagiarism_similarity_setup_form
 *
 * @package   plagiarism_similarity
 * @copyright 2017 Dan Marsden
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class plagiarism_similarity_setup_form extends moodleform {
    /**
     * Form definition
     */
    public function definition () {
        $mform =& $this->_form;
        $mform->addElement('checkbox', 'enabled', get_string('usesimilarity', 'plagiarism_similarity'));

        $mform->addElement('text', 'api', get_string('similarity_api', 'plagiarism_similarity'));
        $mform->addHelpButton('api', 'similarity_api', 'plagiarism_similarity');
        $mform->addRule('api', null, 'required', null, 'client');
        $mform->setDefault('api', '');
        $mform->setType('api', PARAM_URL);
        $mods = core_component::get_plugin_list('mod');
        foreach ($mods as $mod => $modname) {
            if (plugin_supports('mod', $mod, FEATURE_PLAGIARISM)) {
                $modstring = 'enable_mod_' . $mod;
                $mform->addElement('checkbox', $modstring, get_string('similarity_enableplugin', 'plagiarism_similarity', $mod));
                if ($modname == 'assign') {
                    $mform->setDefault($modstring, 0);
                }
            }
        }
        $mform->addElement('select', 'lang', get_string('select_language', 'plagiarism_similarity'), array('english', 'german', 'french'));
        $mform->addHelpButton('lang', 'similarity_lang', 'plagiarism_similarity');
        $mform->addRule('lang', null, 'required', null, 'client');

        $mform->addElement('checkbox', 'rating', get_string('showratingforstudent', 'plagiarism_similarity'));
        $mform->addElement('checkbox', 'report', get_string('showreporttostudent', 'plagiarism_similarity'));
        $mform->addElement('select', 'debugging', get_string('debugging', 'plagiarism_similarity'), array('Disable', 'Enable'));
        $mform->addHelpButton('debugging', 'debugginghelp', 'plagiarism_similarity');

        $this->add_action_buttons(true);
    }
}
