<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * similarity_tabs.php - tabs used in admin interface.
 *
 * @package   plagiarism_similarity
 * @author    Dan Marsden <dan@danmarsden.com>
 * @copyright 2011 onwards Dan Marsden
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$strplagiarism = get_string('similarity', 'plagiarism_similarity');
$strplagiarismdefaults = get_string('similaritydefaults', 'plagiarism_similarity');
$strplagiarismdebug = get_string('similaritydebug', 'plagiarism_similarity');
$strplagiarisallfiles = get_string('similarityallfiles', 'plagiarism_similarity');

$tabs = array();
$tabs[] = new tabobject('similaritysettings', 'settings.php', $strplagiarism, $strplagiarism, false);
$tabs[] = new tabobject('similarityallfiles', 'allfiles.php', $strplagiarisallfiles, $strplagiarisallfiles, false);

print_tabs(array($tabs), $currenttab);
