<?php

require_once(__DIR__ . '/../../../config.php');
global $CFG, $DB,$USER;
require_once("$CFG->libdir/formslib.php");
require_login();

if(!(has_capability('local/hierarchy:user_report_access', context_system::instance()))) { //check capability 
    redirect(new moodle_url('/my'));
}

$page=optional_param('page', 0, PARAM_INT);
$perpage=optional_param('perpage', 10, PARAM_INT);
$paging=$page*$perpage;  


$startdate_filter = optional_param('startdate_filter', 0, PARAM_INT);
$enddate_filter = optional_param('enddate_filter', 0, PARAM_INT);
$username_filter = optional_param('username_filter', '', PARAM_TEXT);
$firstname_filter = optional_param('firstname_filter', '', PARAM_TEXT);
$lastname_filter = optional_param('lastname_filter', '', PARAM_TEXT);
$email_filter = optional_param('email_filter', '', PARAM_TEXT);
$course_fullname_filter = optional_param('course_fullname_filter', '', PARAM_TEXT);
$course_shortname_filter = optional_param('course_shortname_filter', '', PARAM_TEXT);
$course_category_filter = optional_param('course_category_filter', '', PARAM_TEXT);


$PAGE->set_context(context_system::instance());
$PAGE->set_pagelayout('standard');
$PAGE->set_title('User report');
$PAGE->set_heading('User report');

$PAGE->set_url(new moodle_url('/local/hierarchy/reports/user_table.php', array('page'=> $page, 'perpage'=>$perpage, 'username_filter'=>$username_filter, 'firstname_filter'=>$firstname_filter, 'lastname_filter'=>$lastname_filter, 'email_filter'=>$email_filter, 'course_fullname_filter'=>$course_fullname_filter, 'course_shortname_filter'=>$course_shortname_filter, 'course_category_filter'=>$course_category_filter, 'startdate_filter'=>$startdate_filter, 'enddate_filter'=>$enddate_filter)));

$PAGE->requires->css(new moodle_url('/local/hierarchy/reports/style/table.css'));



class simplehtml_form extends moodleform{
   		 public function definition() 
		{
			global $CFG,$course_fullname_filter,$course_shortname_filter,$course_category_filter,$startdate_filter,$enddate_filter,$username_filter,$firstname_filter,$lastname_filter,$email;

			$mform = $this->_form;
			//$buttonarray=array();
		    $mform->addElement('header','filterhead', 'Filter');
          	$mform->setExpanded('filterhead',0);
			$mform->addElement('html','<div class="amit-form">');
				$mform->addElement('html','<div class="row">');
					$mform->addElement('html','<div class="col-md-6">');
						$mform->addElement('text','username','User Name',array('size'=>'40'));
					$mform->addElement('html','</div>');
					
					$mform->addElement('html','<div class="col-md-6">');
						$mform->addElement('text','firstname','First Name',array('size'=>'40'));
					$mform->addElement('html','</div>');
					
					$mform->addElement('html','<div class="col-md-6">');
						$mform->addElement('text','lastname','Last Name',array('size'=>'40'));
					$mform->addElement('html','</div>');
					
					$mform->addElement('html','<div class="col-md-6">');
						$mform->addElement('text','email','Email',array('size'=>'40'));
					$mform->addElement('html','</div>');
					
					$mform->addElement('html','<div class="col-md-6">');
						$mform->addElement('text','coursefullname','Course Fullname',array('size'=>'40'));
					$mform->addElement('html','</div>');
					
					$mform->addElement('html','<div class="col-md-6">');
						$mform->addElement('text','courseshortname','Course Shortname',array('size'=>'40'));
					$mform->addElement('html','</div>');
					
					$mform->addElement('html','<div class="col-md-6">');
						$mform->addElement('text','coursecategory','Course Category',array('size'=>'40'));
					$mform->addElement('html','</div>');
					
					$mform->addElement('html','<div class="col-md-6">');
						$mform->addElement('date_selector','course_start_filter','Course Start Date',array('size'=>'40'));
					$mform->addElement('html','</div>');
				
				
						$year=2000;
						$month=1; 
						$day=1;
						$defaulttime = make_timestamp($year, $month, $day);
						$mform->setDefault('course_start_filter',  $defaulttime);
				
					$mform->addElement('html','<div class="col-md-6">');
						$mform->addElement('date_selector','course_end_filter','Course End Date',array('size'=>'40'));
					$mform->addElement('html','</div>');
				$mform->addElement('html','</div>');
				
				$year=2050;
				$month=1; 
				$day=1;
				$defaulttime = make_timestamp($year, $month, $day);
				$mform->setDefault('course_end_filter',  $defaulttime);
				$mform->addElement('html','<div class="row">');
					$mform->addElement('html','<div class="col-md-12 cus-ami-right-form">');
						
						$mform->addElement('cancel','clear','Clear');
						$mform->addElement('submit','filter','Filter');
					$mform->addElement('html','</div>');					
				$mform->addElement('html','</div>');
		$mform->addElement('html','</div>');
		}
	}

	$mform = new simplehtml_form();
	
    if($mform->is_cancelled())
    {

    	$url= new moodle_url('/local/hierarchy/reports/user_table.php', array('page'=> $page, 'perpage'=>$perpage, 'username_filter'=>$username_filter, 'firstname_filter'=>$firstname_filter, 'lastname_filter'=>$lastname_filter, 'email_filter'=>$email_filter, 'course_fullname_filter'=>$course_fullname_filter, 'course_shortname_filter'=>$course_shortname_filter, 'course_category_filter'=>$course_category_filter, 'startdate_filter'=>$startdate_filter, 'enddate_filter'=>$enddate_filter)); 
        
    	redirect($url);

    }  

    if ($formdata = $mform->get_data()) 
	{
           $course_fullname_filter   = $formdata->coursefullname;
           $course_shortname_filter  = $formdata->courseshortname;
           $course_category_filter   = $formdata->coursecategory;
           $startdate_filter         = $formdata->course_start_filter;
           $enddate_filter           = $formdata->course_end_filter;
           $username_filter          = $formdata->username;
           $firstname_filter         = $formdata->firstname;
           $lastname_filter          = $formdata->lastname;
           $email_filter             = $formdata->email;

	}


//set conditions according to filters
$condition = "";

if($startdate_filter!=0) {
	$condition .= " AND c.startdate > $startdate_filter";
}

if($enddate_filter!=0) {
	$condition .= " AND c.enddate < $enddate_filter"; 
}

if($username_filter!='') {
	$condition .= " AND u.username LIKE '%$username_filter%'";
}

if($firstname_filter!='') {
	$condition .= " AND u.firstname LIKE '%$firstname_filter%'";
}

if($lastname_filter!='') {
	$condition .= " AND u.lastname LIKE '%$lastname_filter%'";
}

if($email_filter!='') {
	$condition .= " AND u.email LIKE '%$email_filter%'";
}

if($course_fullname_filter!='') {
	$condition .= " AND c.fullname LIKE '%$course_fullname_filter%'";
}

if($course_shortname_filter!='') {
	$condition .= " AND c.shortname LIKE '%$course_shortname_filter%'";
}

if($course_category_filter!='') {
	$condition .= " AND cc.name LIKE '%$course_category_filter%'";
}


if((is_siteadmin()) || (user_has_role_assignment($USER->id, $managerRoleId->id)) || (user_has_role_assignment($USER->id, $teacherRoleId->id)))
{ 
     $power_condition = ''; 
}
else if($USER->branchpoweruser == 1)
{
      $power_condition = " AND u.branch = $USER->branch";
}
else if($USER->deptpoweruser == 1)
{
      $power_condition = " AND u.dept = $USER->dept";  
}

$sql_main = "SELECT u.id AS userid, c.id AS courseid, u.idnumber AS useridnumber, u.username, u.firstname, u.lastname, u.email, u.confirmed, u.suspended, u.branch, u.dept, u.address, u.phone2, u.city, u.country, c.idnumber AS courseidnumber, c.fullname AS coursefullname, c.shortname AS courseshortname, c.category AS coursecategoryid, c.startdate AS coursestartdate, c.enddate AS courseenddate, c.visible AS coursevisible, c.timecreated, cc.name AS categoryname

FROM {user} AS u INNER JOIN {user_enrolments} AS ue ON u.id=ue.userid INNER JOIN {enrol} AS e ON ue.enrolid=e.id INNER JOIN {course} AS c on e.courseid=c.id INNER JOIN {course_categories} as cc on c.category=cc.id WHERE 1=1 $condition $power_condition GROUP BY u.id, c.id ORDER BY u.id ASC LIMIT $perpage OFFSET $paging";


$count = "SELECT count(*) as c
FROM {user} AS u INNER JOIN {user_enrolments} AS ue ON u.id=ue.userid INNER JOIN {enrol} AS e ON ue.enrolid=e.id INNER JOIN {course} AS c on e.courseid=c.id INNER JOIN {course_categories} as cc on c.category=cc.id WHERE 1=1 $condition $power_condition";

$total_value = $DB->get_record_sql($count);
$total_value = $total_value->c;


$rs = $DB->get_recordset_sql($sql_main);



$htmltable = new html_table();

$htmltable->attributes['class'] = 'table table-striped table-hover table-bordered custom-table';

$htmltable->head = array('S.No.', 'User ID Number', 'Username', 'First Name', 'Last Name', 'Email', 'Expiration', 'Validation State', 'Level', 'Suspended', 'Suspension date', 'Course ID Number', 'Course Fullname', 'Course Shortname', 'Course Category', 'Course category ID Number', 'Course Start Date', 'Course End Date', 'Course Has Expired', 'Course type', 'Course Duration', 'User Enrolment Start date', 'User Enrolment End date', 'Course Status', 'First access', 'Last access', 'Initial score', 'Final score', 'Course Creation Date', 'Status', 'Completion Date', 'Course Progression', 'Session time', 'Credit (CEUs)', 'Time in webinar', 'Designation','Job role', 'Parent company', 'Branch', 'Dept', 'Mailing Address', 'Mobile No.', 'City', 'Country');


$count=$paging;

foreach ($rs as $record) {

	$count++;

	//set values


	$status='Subscribed';
	
	$sql="SELECT * FROM {course_completions} WHERE userid=$record->userid AND course=$record->courseid";
	if($DB->record_exists_sql($sql)) {
	
		$rec = $DB->get_record('course_completions', array('userid'=>$record->userid, 'course'=>$record->courseid));

		if( ($rec->timecompleted!=0) && ($rec->timecompleted!=NULL) && ($rec->timecompleted!='') ) {
			$status='Completed';
		}

	}

	if($status!='Completed') { //if course is not completed

		$sql="SELECT * FROM {user_lastaccess} WHERE userid=$record->userid AND courseid=$record->courseid";

		if($DB->record_exists_sql($sql)) { //if user has accessed the course at least once
			$status='In progress';
		}

	}


	$total_module = $DB->get_record_sql("SELECT count(module) as c FROM {course_modules} WHERE deletioninprogress = 0 AND course = $record->courseid");
               
               $notcompleted_module = $DB->get_record_sql("SELECT count(module) as uc FROM {course_modules} WHERE completion = 0 AND deletioninprogress = 0  AND course = $record->courseid");

               $total_completion = $DB->get_record_sql("SELECT count(modules.module) as f FROM {course_modules} AS modules INNER JOIN {course_modules_completion} as course_module_result ON modules.id=course_module_result.coursemoduleid WHERE modules.course=$record->courseid AND modules.deletioninprogress=0 AND modules.completion>0 AND course_module_result.userid = $record->userid and course_module_result.completionstate>0");

               $total_completemodule = ($total_module->c)-($notcompleted_module->uc);
               $totaluser_completemodule = $total_completion->f;

               if($status!='Completed')
               {
	               if($total_completemodule && $totaluser_completemodule)
	                {   
	                	$record->course_completion_percent = round(($totaluser_completemodule/$total_completemodule)*100);
	                }
	                else
	                {
	                	$record->course_completion_percent = 0;
	                }
                }
                else
                {
                	$record->course_completion_percent = 100;
                }
                /*if(($total_module->c)==($notcompleted_module->uc))
                {
                    $record->course_completion_percent = 100;
                }*/

                

	// 
	//$record->course_completion_percent=0;

	//
	$validated='Validated';
	if($record->confirmed==0){$validated='Not validated';}

	//
	$suspended='No';
	if($record->suspended==1) {$suspended='Yes';}

	//
	$coursecategory='-';
	$coursecategoryidnumber='-';


	$coursecategory=$record->categoryname;
	$catid=$DB->get_record_sql("SELECT * FROM {course_categories} WHERE id=$record->coursecategoryid");
    if($catid->idnumber != null)
    {
 		$coursecategoryidnumber=$catid->idnumber;
    }

	//
	$coursestartdate='-';
	$courseenddate='-';
	if($record->coursestartdate!=0) {$coursestartdate=date('d/m/Y', $record->coursestartdate);}
	if($record->courseenddate!=0) {$courseenddate=date('d/m/Y', $record->courseenddate);}

	//
	$coursehasexpired='No';
	if($record->courseenddate < time() && $record->courseenddate != 0) {$coursehasexpired='Yes';}

	//
	$courseduration='Unlimited';
	if($record->courseenddate != 0) {
		$timeDiff= abs($record->courseenddate - $record->coursestartdate);
		$days = ceil($timeDiff/86400);
		$courseduration = $days . " days";
	}

	//
	$userenrolstartdate='-';
	$userenrolenddate='-';

	$sql0="SELECT * FROM {enrol} WHERE courseid=$record->courseid";

	$sql="SELECT * FROM ($sql0) AS e INNER JOIN {user_enrolments} AS u ON e.id=u.enrolid WHERE u.userid=$record->userid LIMIT 1";

	$enrolment=$DB->get_record_sql($sql);

	if($enrolment->timestart!=0) {$userenrolstartdate = date('d/m/Y', $enrolment->timestart);}
	if($enrolment->timeend!=0) {$userenrolenddate = date('d/m/Y', $enrolment->timeend);}

	//
	$coursestatus='Not published';
	if($record->coursevisible==1) {$coursestatus='Published';}

	//
	$coursecreationdate='-';
	if($record->timecreated!=0) {$coursecreationdate=date('d/m/Y', $record->timecreated);}

	//
	

	//
	$coursecompletiondate='-';
	if($status=='Completed') {
		$a=$DB->get_record('course_completions', array('userid'=>$record->userid, 'course'=>$record->courseid));
		$coursecompletiondate=date('d/m/Y', $a->timecompleted);
	}

	//
	$branch='-';
	$dept='-';
	if($record->branch!=0) {
		$branchrecord=$DB->get_record('loc_framework', array('id'=>$record->branch));
		$branch=$branchrecord->fullname;
	}
	if($record->dept!=0) {
		$deptrecord=$DB->get_record('loc', array('id'=>$record->dept));
		$dept=$deptrecord->fullname;
	}

    if($record->country)
    {
        $country= get_string($record->country,'countries'); 
    }
    else
    {
    	$country='';
    }
    if($record->courseidnumber)
    {
        $courseidnumber = $record->courseidnumber; 
    }
    else
    {
        $courseidnumber = '-';  
    }
    if($record->useridnumber)
    {
    	$useridnumber =  $record->useridnumber;
    }
    else
    {
        $useridnumber = '-';	
    }

    //
    $firstaccess = '-';
    $lastaccess = '-';

    if( $DB->record_exists('user_lastaccess', array('courseid'=>$record->courseid, 'userid'=>$record->userid)) ) { //if course has been accessed

    	$last_acces_record = $DB->get_record('user_lastaccess', array('courseid'=>$record->courseid, 'userid'=>$record->userid));

    	$lastaccess = $last_acces_record->timeaccess;
    	$lastaccess = date('d/m/Y h:i A', $lastaccess);


    	$first_access_sql = "SELECT * FROM {logstore_standard_log} WHERE action='viewed' AND target='course' AND userid=$record->userid AND courseid=$record->courseid ORDER BY timecreated ASC LIMIT 1";

    	$first_acces_record = $DB->get_record_sql($first_access_sql);

    	$firstaccess = $first_acces_record->timecreated;
    	$firstaccess = date('d/m/Y h:i A', $firstaccess);

    }


	$htmltable->data[] = array($count, $useridnumber, $record->username, $record->firstname, $record->lastname, $record->email, 'null', $validated, 'null', $suspended, 'null', $courseidnumber, $record->coursefullname, $record->courseshortname, $coursecategory, $coursecategoryidnumber, $coursestartdate, $courseenddate, $coursehasexpired, 'null', $courseduration, $userenrolstartdate, $userenrolenddate, $coursestatus, $firstaccess, $lastaccess, 'null', 'null', $coursecreationdate, $status, $coursecompletiondate, $record->course_completion_percent, 'null', 'null', 'null', 'null', 'null', 'null', $branch, $dept, $record->address, $record->phone2, $record->city, $country);

} 

$rs->close(); // Don't forget to close the recordset!



echo $OUTPUT->header();

/////////
	$tabs = array();
	$row = array();
	$activated = array();
	$inactive=array();
	$currenttab='User';
	 
	 
	 
	$pending1url = new moodle_url('/local/hierarchy/reports/user_table.php');
	$row[] = new tabobject('User', $pending1url->out(), 'User Report');

	$pending2url = new moodle_url('/local/hierarchy/reports/user_course_completion.php');
	$row[] = new tabobject('Course', $pending2url->out(),  'Course Report');


	$tabs[] = $row;
	$activated[] = $currenttab;
	print_tabs($tabs, $currenttab, $inactive, $activated);
	
////////






$systemcontext = context_system::instance();
    if(has_capability('local/hierarchy:course_report_filter',$systemcontext))
    {
    	$mform->display();
	}


 $systemcontext = context_system::instance();
    if(has_capability('local/hierarchy:course_report_download',$systemcontext))
    {
			echo html_writer::start_tag('div',array('class'=>'span6 span6-custom')).
			html_writer::start_tag('a',array('href'=>'#','class'=>'download')).html_writer::start_tag('img',array('class'=>'iconimg','src'=>'style/img/dowload.svg')).html_writer::end_tag('a').
		html_writer::end_tag('div');
    }

if(!$total_value)
{
	$a = new html_table_cell("No records found");
	$a->colspan=44;
    $htmltable->data[] = new html_table_row(array($a));
}

echo html_writer::start_tag('div',array('style'=>'overflow:auto'));
echo html_writer::table($htmltable);
echo html_writer::end_tag('div');


$paging_url = new moodle_url('/local/hierarchy/reports/user_table.php', array('page'=> $page, 'perpage'=>$perpage, 'username_filter'=>$username_filter, 'firstname_filter'=>$firstname_filter, 'lastname_filter'=>$lastname_filter, 'email_filter'=>$email_filter, 'course_fullname_filter'=>$course_fullname_filter, 'course_shortname_filter'=>$course_shortname_filter, 'course_category_filter'=>$course_category_filter, 'startdate_filter'=>$startdate_filter, 'enddate_filter'=>$enddate_filter));


//count total records with filter but without pagination

echo $OUTPUT->paging_bar($total_value, $page, $perpage, $paging_url);

echo $OUTPUT->footer();

?>


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script>

$(document).ready(function() { 
			

	$(".iconimg").click(function(event){  
				
		window.location.href = "user_table_excel.php?condition_string=<?php echo urlencode($condition); ?>"; 
					
	});
				
});

</script>
