<?php
 // Test table class to be put in test_table.php of root of Moodle installation.
 // for defining some custom column names and proccessing
 // Username and Password feilds using custom and other column methods.
 
class assign_table extends table_sql {

    /**
     * Constructor
     * @param int $uniqueid all tables have to have a unique id, this is used
     *      as a key when storing table properties like sort order in the session.
     */
    function __construct($uniqueid) {
        parent::__construct($uniqueid);
        // Define the list of columns to show.
        $columns = array('id','username','link','aws','supported');
        $this->define_columns($columns);

        // Define the titles of columns to show in header.
        $headers = array('id','Username','link','AWS','supported');
        $this->define_headers($headers);
    }

    /**
     * This function is called for each data row to allow processing of the
     * username value.
     *
     * @param object $values Contains object with all the values of record.
     * @return $string Return username with link to profile or username only
     *     when downloading.
     */
    function col_link($values) {
        // If the data is being downloaded than we don't want to show HTML.
        $cm = get_coursemodule_from_instance('assignment', 5, 2);
        $context = get_context_instance(CONTEXT_MODULE, 5);

        $url = moodle_url::make_pluginfile_url($values->contextid,$values->component,$values->filearea,$values->itemid,$values->filepath,$values->filename,false);

        // return $url;
        if($values->mimetype == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
        {
            return "<a href=#>$values->filename</a>";
        }
        elseif($values->mimetype == "application/pdf")
        {
            return "<a href='$url' target='_blank'>$values->filename</a>";
        }
        // return "hii";
        // return "<a href=$url>$values->filename</a>"; 
        // return "<a href='https://docs.google.com/gview?url=$url&amp;embedded=true'>$values->filename</a>";
        // return '<iframe src="https://docs.google.com/gview?url='.$url.'&amp;embedded=true" width="100%" height="700"></iframe>';
    }

    function col_supported($values)
    {
        if($values->mimetype == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
        {
            return "Not supported";
        }
        elseif($values->mimetype == "application/pdf")
        {
            return "Supported";
        }
    }


    function col_username($values)
    {
        global $DB;
        $user_data = $DB->get_record('user',array('id' => $values->userid));
        return $user_data->username;
    }

    function col_aws($values)
    {
        if($values->mimetype == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
        {
            return "<a href='$values->aws_url'>$values->aws_url</a>";
        }
        elseif($values->mimetype == "application/pdf")
        {
            return "<a href='$values->aws_url' target='_blank'>$values->aws_url</a>";
        }
        // return $values->aws_url;
    }
}