<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package   mod_forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

function local_aws_plugin_extend_navigation(global_navigation $nav3) {
    global $CFG, $PAGE, $DB, $USER;
    // $nav3->add(
    // 'Asssignment Listing',
    // new moodle_url($CFG->wwwroot . '/local/aws_plugin/index.php'),
    // navigation_node::TYPE_SYSTEM,
    // null,
    // 'local_aws_plugin',
    // $icon
    // )->showinflatnavigation = true;
}

function aws_connect($eventdata) {

      global $CFG, $DB, $PAGE;
      require_once("$CFG->dirroot/mod/assign/locallib.php");
      require_once("$CFG->dirroot/mod/assign/submission/file/locallib.php");
      $cmid = $eventdata['contextinstanceid'];
      $modulecontext = context_module::instance($cmid);

      $fs = get_file_storage();
      $files = $fs->get_area_files($modulecontext->id, 'assignsubmission_file', ASSIGNSUBMISSION_FILE_FILEAREA,
      $eventdata['objectid'], "id", false);

    foreach ($files as $file) {
        $filename = $file->get_filename();
        $url = moodle_url::make_pluginfile_url($file->get_contextid(), $file->get_component(), $file->get_filearea(),
        $file->get_itemid(), $file->get_filepath(), $filename, false);
        $starting = substr($file->get_contenthash(), 0, 2);
        $next = substr($file->get_contenthash(), 2, 2);
        $filedetails = new StdClass();
        $filedetails->url = $CFG->dataroot.'/filedir'.'/'.$starting.'/'.$next.'/'.$file->get_contenthash();
        $filedetails->name = $filename;
        $filedetails->objectid = $eventdata['objectid'];
        $filedetails->module_id = $cmid;
        $filedetails->contextid = $modulecontext->id;
        $filedetails->base_url = "$CFG->wwwroot/local/aws_plugin/test.php";

          $out[] = $filedetails;
    }
    require_once("$CFG->dirroot/local/aws_plugin/aws_download.php");
    foreach ($out as $outvalue) {
        $url = $outvalue->url;
        $name = $outvalue->name;
        $contextid = $outvalue->contextid;
        $moduleid = $outvalue->module_id;
        $objectid = $outvalue->objectid;
        $baseurl = $outvalue->base_url;
        aws_downoad_link($url, $name, $contextid, $moduleid, $objectid, $baseurl);
    }
}


