<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * plagiarism.php - allows the admin to configure plagiarism stuff
 *
 * @package   plagiarism_similarity
 * @author    Dan Marsden <dan@danmarsden.com>
 * @copyright 2011 onwards Dan Marsden
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


require_once(dirname(dirname(__FILE__)) . '/../config.php');
require_once($CFG->libdir.'/adminlib.php');
require_once($CFG->libdir.'/plagiarismlib.php');
require_once($CFG->dirroot.'/plagiarism/similarity/lib.php');

require_login();
admin_externalpage_setup('plagiarismsimilarity');

plagiarism_similarity_checkcronhealth();

$context = context_system::instance();
require_capability('moodle/site:config', $context, $USER->id, true, "nopermissions");

$mform = new plagiarism_similarity_setup_form();
if ($mform->is_cancelled()) {
    redirect('/my');
}

echo $OUTPUT->header();

$currenttab = 'similaritysettings';

require_once('similarity_tabs.php');

if (($data = $mform->get_data()) && confirm_sesskey()) {
    if (!isset($data->enabled)) {
        $data->enabled = 0;
    }

    $supportedmodules = similarity_supported_modules();
    foreach ($supportedmodules as $mod) {
        if (plugin_supports('mod', $mod, FEATURE_PLAGIARISM)) {
            $modstring = 'enable_mod_' . $mod;
            if (!isset($data->$modstring)) {
                $data->$modstring = 0;
            }
        }
    }
    // This form contains some checkboxes - set them to 0 if needed.
    $checkboxes = ['rating', 'report', 'debugging'];
    foreach ($checkboxes as $c) {
        if (!isset($data->$c)) {
            $data->$c = 0;
        }
    }

    foreach ($data as $field => $value) {
        if ($field != 'submitbutton') { // Ignore the button.
            $value = trim($value); // Strip trailing spaces to help prevent copy/paste issues with username/password.
            if ($field == 'api') { // Strip trailing slash from api.
                $value = rtrim($value, '/');
            }
            set_config($field, $value, 'plagiarism_similarity');
        }
    }

    if (!defined('BEHAT_SITE_RUNNING')) {
        $c = new curl(array('proxy' => true));
        $c->setopt(array('CURLOPT_RETURNTRANSFER' => 1,
            'CURLOPT_TIMEOUT' => 60, // Set to 60seconds just in case.
            'CURLOPT_HTTPAUTH' => CURLAUTH_BASIC
        ));

        $header = array();
        $header[] = "Content-Type: application/json";
        $header[] = "x-doco-apikey: $data->api";
        $c->setHeader($header);
        $baseurl = 'https://www.docoloc.de/rv1';
        $html = $c->get($baseurl .'/jobs');
        $response = $c->getResponse();

    } else {
        // Fake a success for unit tests.
        $c = new stdClass();
        $c->info['http_code'] = '200';


    }
    // Now check to see if username/password is correct. - this check could probably be improved further.
    if ($c->info['http_code'] != '200') {
        // Disable similarity as this config isn't correct.
        set_config('enabled', 0, 'plagiarism_similarity');
        echo $OUTPUT->notification(get_string('savedconfigfailed', 'plagiarism_similarity'), 'notifyproblem');
        debugging("invalid httpstatuscode returned: ".$c->info['http_code']);
    } else {
        echo $OUTPUT->notification(get_string('savedconfigsuccess', 'plagiarism_similarity'), 'notifysuccess');
    }
}

$plagiarismsettings = (array)get_config('plagiarism_similarity');
$mform->set_data($plagiarismsettings);

echo $OUTPUT->box_start('generalbox boxaligncenter', 'intro');
$mform->display();
echo $OUTPUT->box_end();
echo $OUTPUT->footer();
