<?php 

require('../../config.php');
require_once($CFG->dirroot.'/course/lib.php');
global $CFG,$DB,$USER;

// $catid = required_param('catid',PARAM_INT);
// $depth = required_param('depth',PARAM_INT);
$catid = $_GET['catid'];
$depth = $_GET['depth'];
$extra_classes = $_GET['extra_classes'];
// $extra_classes = required_param('extra_classes',PARAM_RAW);

$margin = ($depth + 1)*20;

$margin .= 'px;';


$html = "";








$courses=enrol_get_all_users_courses($USER->id);
$courseid_array=array();
$catid_array=array();

foreach($courses as $course) {
	$courseid_array[]=$course->id; //get arrays of ids of courses and categories the user is enrolled in
	$catid_array[]=$course->category;
}

$catid_array = array_unique($catid_array); //remove duplicate entries




function get_course_image_url($courseid) {

	global $DB;

	$course_record=$DB->get_record('course', array('id'=>$courseid));
	$course = new core_course_list_element($course_record); //get object

	$overview_files = $course->get_course_overviewfiles(); //call function to get overview file

	if(count($overview_files) < 1) { //if no course image is set array will be empty
		return '../blocks/simplehtml/images/noimg.jpg'; //return url of default pic
	}

	foreach($overview_files as $file) { //there should be only one overview file in the array, the course image

		if($file->is_valid_image()) { //if it is an image

			$fileurl = moodle_url::make_file_url('/pluginfile.php', '/' . $file->get_contextid() . '/' . $file->get_component() . '/' . $file->get_filearea() . '/' . $file->get_filename());

			return $fileurl; //return url of file

		} else {

			return '../blocks/simplehtml/images/noimg.jpg'; //return url of default pic

		}

	}	


}


function get_course_completion_html($courseid) {

	global $DB, $USER;


	$status='Subscribed';
	
	$sql="SELECT * FROM {course_completions} WHERE userid=$USER->id AND course=$courseid";
	if($DB->record_exists_sql($sql)) {
	
		$rec = $DB->get_record('course_completions', array('userid'=>$USER->id, 'course'=>$courseid));

		if( ($rec->timecompleted!=0) && ($rec->timecompleted!=NULL) && ($rec->timecompleted!='') ) {
			$status='Completed';
		}

	}

	if($status!='Completed') { //if course is not completed

		$sql="SELECT * FROM {user_lastaccess} WHERE userid=$USER->id AND courseid=$courseid";

		if($DB->record_exists_sql($sql)) { //if user has accessed the course at least once
			$status='In progress';
		}

	}






    $html='';
    if($status=='In progress') {
    	$html = '<i class="fa fa-circle" aria-hidden="true" title="In progress" style="color:red;"></i>';
    }
	
	if($status=='Completed') {
		$html = '<i class="fa fa-check-circle" aria-hidden="true" title="Completed" style="color:green"></i>';
	}

	

	return $html;

}






$result1 = $DB->get_records('course_categories', array('parent'=>$catid)); //get all children categories under the clicked category

$printable_categories=array(); //array to store records of all categories to be printed
if($result1)
{
	foreach($result1 as $record1) { //for each child category

		$params = array($record1->path,        //path of the category itself
			"$record1->path/%"       //path pattern of descendents
			);
	
		$sql = "SELECT * from {course_categories}
			WHERE path = ? || path LIKE ?";
	
		$result2=$DB->get_records_sql($sql, $params);  //get the category itself and its decendents
	
		$flag=0;
	
		foreach($result2 as $record2) { //for each of them
	
			if(in_array($record2->id, $catid_array)) {
				$flag=1; //if the category itself or any of its descendents is in list
			}
	
		}
	
		if($flag==1) {
			$printable_categories[]= clone $record1; //category is to be printed, append to array
		}
	
	}
}














if(count($printable_categories) > 0) {
	
	foreach($printable_categories as $category) {
		
		$html .= "<div class='category-block' style='margin-top:10px; margin-left: $margin'>

			<span class='accordion unfetched triangle-right' id='$category->id' data-depth='0' style='cursor: pointer;'> 
				<img src='../blocks/simplehtml/images/righttriangle.png' style='width: 12px; height: 12px; margin-bottom: 5px;margin-right: 3px;'>
			</span>

			<span>
				<h3 class='categoryname' style='display:inline;'>
					<span class='accordion' id='$category->id' style='cursor:pointer;'>$category->name</span>
				</h3>
			</span>

			<span>
				<img id='" . $category->id . "_loader' src='../blocks/simplehtml/images/loader.gif' style='display: none; width: 17px; margin-bottom: 8px;'>
			</span>

			<div id='" . $category->id . "_child'></div>

		</div>";
		
	}
	
}





$result3=$DB->get_records('course', array('category'=>$catid)); //get all courses under the clicked category

$courseflag=0;
if($result3)
{
	foreach($result3 as $course) {

		if(in_array($course->id, $courseid_array)) {
			$courseflag=1; //if at least one course is to be printed, set the flag
		}
	
	}	
}
	

if($courseflag==1) { //show the heading 'Available courses' if flag is set
	$html .= "<h3 class='categoryname' style='margin-top:10px; margin-left: $margin'>
		My courses
	</h3>";
}


$html .= "<div class='row $extra_classes'>"; //div to contain all courses
 
if($result3)
{
	foreach($result3 as $course) {

		if(in_array($course->id, $courseid_array)) { //if course is to be printed
	
			$category_rec = $DB->get_record('course_categories', array('id'=>$course->category));
	
			$url=get_course_image_url($course->id);
	
			$completion_html = get_course_completion_html($course->id);
			
			$html .= '<div class="col-md-4">
				<div class="class-box" style="    border: 0!important;
				border-bottom: 7px solid #3fcbda!important;
				background-color: #f8f9fa;">		
					<a href="'.$CFG->wwwroot.'/course/view.php?id=' . $course->id . '">
						<div class="courseimagecontainer">
							<div class="course-image-view" style="background-image: url(' . $url . '); background-repeat: no-repeat; background-size:cover; background-position:center; padding: 100px">
							</div>
							<div class="course-overlay">
								<i class="fa fa-arrow-circle-right" aria-hidden="true"></i>
							</div>
						
						</div>
						<div style="padding:0px 20px 10px;">
						<div class="course-title">
							<h4>
							<span class="pull-left">' . $course->fullname . '</span>
							<span class="pull-right">' . $completion_html . '</span>
							<div class="clearfix"></div>
						</h4>
						</div>
					</a>
					<div class="course-summary">
						<div class="coursecat">Category: 
							<a class="" href="../../course/index.php?categoryid=' . $category_rec->id . '">' . $category_rec->name . '
							</a>
						</div>
					
					</div>
				</div>
				</div>
			</div>';
	
		}
	
	}
}


$html .= "</div>"; // end div containing all courses

if($courseflag==1) {
	$html .= "<hr style='width: 96%;'>";
}

echo $html;
