<?php

require_once('../../config.php');
require_once('lib.php');
require_once($CFG->libdir . '/moodlelib.php');
require_login();
global $DB;
echo $OUTPUT->header();
purge_caches();
$html='<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <title>Form</title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
  <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.slim.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
</head>
<body>



  <div class="container" id="Manual-Assignment100">
    <div class="row my-4">
      <div class="col-md-12 mx-auto">
        <h5 class="mb-3 text-white"><b>Automatic Assignment Form</b></h5>
        <form class="form" method="get" id="formid" action="formsubmit.php">
        <div class="row">
          
          <div class="col-12 col-6">
            <label class="d-block"><b>Name:</b></label>
            <input type="text" id="name" name="name" class="d-block w-100 input form-control">
            <span class="error1 col-md-8 pl-0"></span>
          </div>
      
          
     
         <div class="col-12 col-6">
          <label class="d-block"><b>Username:</b></label>
          <input type="text" id="username" name="username" class="d-block w-100 input form-control">
          <span class="error1 col-md-8 pl-0"></span>
         </div>
       
         <div class="col-12 col-6">
          <label class="d-block"><b>Tenant Domain:</b></label>
          <input type="text" id="userdomain" name="userdomain" class="d-block w-100 input form-control">
         </div>
          
          <div class="col-12 col-6">
            <label class="d-block"><b>Start Date:</b></label>
          <input type="date" name="start_date" id="start_date" class="d-block w-100 input form-control" />
          </div>
         

          <div class="col-12 col-6">
            <label class="d-block"><b>End Date:</b></label>
            <input type="date" name="end_date" id="end_date" class="d-block w-100 input form-control" />
          </div>
          
          
          <div class="col-12 col-6">
            <label class="d-block"><b>Renewal Reminder Date:</b></label>
          <input type="date" name="renewal_date" id="renewal_date" class="d-block w-100 input form-control" />
          <span class="error1 col-md-8 pl-0"></span>
          </div>



         
          <div class="col-12 col-6">
            <label class="d-block"><b>Password:</b></label>
              <div class="pwd">
                <input type="password" id="userpassword" name="userpassword" class="d-block w-100 input form-control">
                <i class="fa fa-eye-slash absolute" aria-hidden="true"></i>
              </div>
              <span class="error1 col-md-8 pl-0"></span>
          </div>
        
         <div class="col-12 col-6">
          <label class="d-block"><b>Choose a Category:</b></label>
          <div class="multiselect">
            <div class="selectBox" onclick="showCheckboxes()">
              <select class="form-control">
                <option>Select an option</option>
              </select>
              <div class="overSelect"></div>
            </div>
            <div id="checkboxes mt-3">';
          $alldata=$DB->get_records_sql("SELECT * FROM {course_categories} WHERE parent=0 and tenant_id=2");  
          foreach($alldata as $alldatavalue)
          {
            $html.='
           <input type="checkbox" class="form-check-label" name="Category[]" value="'.$alldatavalue->id.'" / style="margin-right:10px;"> <label class="">'.$alldatavalue->name.'</label>';
          }
          $html.='</div>
          </div>
         </div>



        </div>

          <div class="text-center my-4">
            <button type="button" onclick="check()" class="submit"><b>Create Tenant</b></button>
          </div>
        </form>
      </div>
    </div>
  </div>
 <script>
 $(document).ready(function (){
  var typ = $(\'[type="password"]\');
  $(".absolute").click(function () {
      $(this).toggleClass("fa-eye fa-eye-slash");

      if (typ.attr("type") === "password") {
          typ.attr("type", "text");
      } else {
          typ.attr("type", "password");
      }
  });
  $(".page-header-headings h1").text("Automatic Assignment");
});





var expanded = false;

function showCheckboxes() {
  var checkboxes = document.getElementById("checkboxes");
  if (!expanded) {
    checkboxes.style.display = "block";
    expanded = true;
  } else {
    checkboxes.style.display = "none";
    expanded = false;
  }
}

function check()
{
  var name = $("#name").val();
  var username = $("#username").val();
  var userdomain = $("#userdomain").val();
  var userpassword = $("#userpassword").val();
  var status=true;

  if((!userpassword) && (!userdomain) && (!username) && (!name))
  {
    $(".error1").text("* this is required");
    $(".input").css("border","1px solid red");
    $(".error1").show();
  }
  if((!name.trim().length))
  {
    status=false;
    document.getElementsByClassName("error1")[0].innerHTML ="* this is required";
    document.getElementsByClassName("error1")[0].style.display="block";
    document.getElementsByClassName("input")[0].style.borderColor = "red";

  }
  else
  {
    document.getElementsByClassName("error1")[0].innerHTML ="";
    document.getElementsByClassName("error1")[0].style.display="none";
    document.getElementsByClassName("input")[0].style.borderColor = "";
  }

  if((!username.trim().length))
  {
    status=false;
    document.getElementsByClassName("error1")[1].innerHTML ="* this is required";
    document.getElementsByClassName("error1")[1].style.display="block";
    document.getElementsByClassName("input")[1].style.borderColor = "red";

  }
  else
  {
    document.getElementsByClassName("error1")[1].innerHTML ="";
    document.getElementsByClassName("error1")[1].style.display="none";
    document.getElementsByClassName("input")[1].style.borderColor = "";
  }

  if((!userdomain.trim().length))
  {
    status=false;
    document.getElementsByClassName("error1")[2].innerHTML ="* this is required";
    document.getElementsByClassName("error1")[2].style.display="block";
    document.getElementsByClassName("input")[2].style.borderColor = "red";

  }
  else
  {
    document.getElementsByClassName("error1")[2].innerHTML ="";
    document.getElementsByClassName("error1")[2].style.display="none";
    document.getElementsByClassName("input")[2].style.borderColor = "";
  }

  if((!userpassword.trim().length))
  {
    status=false;
    document.getElementsByClassName("error1")[3].innerHTML ="* this is required";
    document.getElementsByClassName("error1")[3].style.display="block";
    document.getElementsByClassName("input")[3].style.borderColor = "red";

  }
  else
  {
    document.getElementsByClassName("error1")[3].innerHTML ="";
    document.getElementsByClassName("error1")[3].style.display="none";
    document.getElementsByClassName("input")[3].style.borderColor = "";
  }
  if(status)
  {
    $.ajax({
      type: "get",
      url: "validate.php",
      data: {name:name,username:username,userdomain:userdomain},
      success: function(data) {
        if(data)
        {
          alert(data);
        }
        else
        {
          $("#formid").submit();
        }

      }


     });
  }


}


 </script>
</body>

</html>';
echo $html;
echo $OUTPUT->footer();