<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Page for creating or editing course category name/parent/description.
 *
 * When called with an id parameter, edits the category with that id.
 * Otherwise it creates a new category with default parent from the parent
 * parameter, which may be 0.
 *
 * @package    core_course
 * @copyright  2007 Nicolas Connault
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once('../config.php');
require_once($CFG->dirroot.'/course/lib.php');

require_login();
global $manageurl1;
$id = optional_param('id', 0, PARAM_INT);
$prev_page = optional_param('prev','', PARAM_TEXT);

//** code by vv */
if ($prev_page) {
    if ($prev_page == 'view-course') {
        $subtile_1 = 'Add new Track ';
    }
    
    if ($prev_page == 'course') {
        $subtile_1 = 'Add new Course ';
    }
}

//** end  code by vv */

$url = new moodle_url('/course/editcategory.php');
if ($id) {
    $coursecat = core_course_category::get($id, MUST_EXIST, true);
    $category = $coursecat->get_db_record();
    $context = context_coursecat::instance($id);
//**************code by vv*************** */
if (!$DB->record_exists('course_categories',['id'=>$id,'usercreated'=>$USER->id])) {
    throw new moodle_exception('sory you do not have permission to edit '.$category->name.'','core');
}


    $parent_id = $DB->get_field('course_categories','parent',['id'=>$id]);
    if ($parent_id > 0) {
        $parent_id = $parent_id;
        $node = $PAGE->navigation->add('Tracks', new moodle_url('/local/public/view-courses.php'), navigation_node::TYPE_CONTAINER);
        $previewnode = $node ->add('Course', new moodle_url('/local/public/courses.php?id='.$parent_id.''), navigation_node::TYPE_CONTAINER);
        $previewnode1 = $previewnode->add('Edit Course ', new moodle_url(''), navigation_node::TYPE_CONTAINER);
        $previewnode1->make_active();
    }
    elseif ($parent_id == 0) {
            $previewnode = $PAGE->navigation->add('Tracks', new moodle_url('/local/public/view-courses.php'), navigation_node::TYPE_CONTAINER);
            $previewnode1 = $previewnode->add('Edit Track ', new moodle_url(''), navigation_node::TYPE_CONTAINER);
            $previewnode1->make_active();
        # code...
    }
//**************end code by vv*************** */

    $coursecat = core_course_category::get($id, MUST_EXIST, true);
    $category = $coursecat->get_db_record();
    $context = context_coursecat::instance($id);
    navigation_node::override_active_url(new moodle_url('/course/index.php', ['categoryid' => $category->id]));
    // $PAGE->navbar->add(get_string('settings'));
    $PAGE->set_primary_active_tab('home');
    $PAGE->set_secondary_active_tab('edit');

    $url->param('id', $id);
    // $strtitle = new lang_string('editcategorysettings');
    if ($prev_page) {
        if ($prev_page == 'view-course') {
        $strtitle = 'Edit Track Settings';
        }
        if ($prev_page == 'course') {
            $strtitle = 'Edit Course Settings';

        }

    }
    else {
        $strtitle = new lang_string('editcategorysettings');

    }

    $itemid = 0; // Initialise itemid, as all files in category description has item id 0.
    $title = $strtitle;
    $fullname = $coursecat->get_formatted_name();

} else {
  
    $parent = required_param('parent', PARAM_INT);
    $parent_id = $parent;
    $url->param('parent', $parent);
    $strtitle = $subtile_1;
    if ($prev_page == 'view-course') {
        $previewnode = $PAGE->navigation->add('Tracks', new moodle_url('/local/public/view-courses.php'), navigation_node::TYPE_CONTAINER);
        $thingnode = $previewnode->add('Add a Track', new moodle_url(''), navigation_node::TYPE_CONTAINER);
        $thingnode->make_active();
        
    }
    if ($parent) {

        $parentcategory = $DB->get_record('course_categories', array('id' => $parent), '*', MUST_EXIST);
        if (!$DB->record_exists('course_categories',['id'=>$parent,'usercreated'=>$USER->id])) {
            throw new moodle_exception('sory you do not have permission to add course in '.$parentcategory->name.'','core');
        }
        
        $context = context_coursecat::instance($parent);
        navigation_node::override_active_url(new moodle_url('/course/index.php', ['categoryid' => $parent]));
        $fullname = format_string($parentcategory->name, true, ['context' => $context->id]);
        $title = "$fullname: $strtitle";

        $managementurl = new moodle_url('/course/management.php');
        // These are the caps required in order to see the management interface.
        $managementcaps = array('moodle/category:manage', 'moodle/course:create');
        if (!has_any_capability($managementcaps, context_system::instance())) {
            // If the user doesn't have either manage caps then they can only manage within the given category.
            $managementurl->param('categoryid', $parent);
        }
        if (!$prev_page) {
            $PAGE->set_primary_active_tab('home');
            $PAGE->navbar->add(get_string('coursemgmt', 'admin'), $managementurl);
            $PAGE->navbar->add(get_string('addcategory', 'admin'));
        }
        else {
            
            
            if ($prev_page == 'course') {
                $previewnode = $PAGE->navigation->add('Tracks', new moodle_url('/local/public/view-courses.php'), navigation_node::TYPE_CONTAINER);

                $thingnode = $previewnode->add('Courses', new moodle_url('/local/public/courses.php?id='.$parent), navigation_node::TYPE_CONTAINER);

                $newnode = $thingnode->add('Add a Course', new moodle_url(''), navigation_node::TYPE_CONTAINER);
                $newnode->make_active();
            }
           
        }
  

    } else {
        $context = context_system::instance();
        $fullname = $SITE->fullname;
        $title = "$SITE->shortname: $strtitle";
        $PAGE->set_secondary_active_tab('courses');
    }

    $category = new stdClass();
    $category->id = 0;
    $category->parent = $parent;
    $itemid = null; // Set this explicitly, so files for parent category should not get loaded in draft area.
}

require_capability('moodle/category:manage', $context);

$PAGE->set_context($context);
$PAGE->set_url($url);
$PAGE->set_pagelayout('admin');
$PAGE->set_title($title);
$PAGE->set_heading($fullname);

$mform = new core_course_editcategory_form('editcategory.php?prev='.$prev_page.'', array(
    'categoryid' => $id,
    'parent' => $category->parent,
    'context' => $context,
    'itemid' => $itemid
));
$mform->set_data(file_prepare_standard_editor(
    $category,
    'description',
    $mform->get_description_editor_options(),
    $context,
    'coursecat',
    'description',
    'text_description',
    $itemid
));

$manageurl = new moodle_url('/course/management.php');   
//**************code by vv*************** */

if ($prev_page == "view-course") {
    $manageurl = new moodle_url('/local/public/view-courses.php');
}
else if ($prev_page == 'course') {
    if (condition) {
        # code...
    }
    $manageurl = new moodle_url('/local/public/courses.php?id='.$parent_id.'');
}

//**************end code by vv*************** */

if ($mform->is_cancelled()) {
    if ($id && $prev_page == ' ') {
            $manageurl->param('categoryid', $id);
        
    } else if ($parent && $prev_page == ' ') {
            $manageurl->param('categoryid', $parent);
       
    }
    redirect($manageurl);
} else if ($data = $mform->get_data()) {


    $course= $DB->get_record('course_categories',['id'=>$data->id]);
    if (isset($coursecat)) {
     
        if ((int)$data->parent !== (int)$coursecat->parent && !$coursecat->can_change_parent($data->parent)) {
            throw new \moodle_exception('cannotmovecategory');
        }
        $coursecat->update($data, $mform->get_description_editor_options());
        if ($data->certificateid) {
            $DB->execute("UPDATE {custom_certificate} SET track_id = NULL WHERE track_id = '$data->id'");
      
            $DB->execute("UPDATE {custom_certificate} SET track_id = '$data->id' WHERE id = '$data->certificateid'");
        }
        if ($course->parent) {
         
            $DB->execute("UPDATE {custom_badge} SET course_id = NULL WHERE course_id = '$data->id'");
      
            $DB->execute("UPDATE {custom_badge} SET course_id = '$data->id' WHERE id = '$data->badgeid'");
        }

    } else {
       
        $category = core_course_category::create($data, $mform->get_description_editor_options());
 
        if ($data->certificateid) {
            # code...
            $DB->execute("UPDATE {custom_certificate} SET track_id = '$category->id' WHERE id = '$data->certificateid'");
        }
        else {
            
            $DB->execute("UPDATE {custom_badge} SET course_id = '$category->id' WHERE id = '$data->badgeid'");
        }
     
    }

    if ($prev_page == '') {
        $manageurl->param('categoryid', $category->id);

    }

    redirect($manageurl);
}

echo $OUTPUT->header();
echo $OUTPUT->heading($strtitle);
$mform->display();
echo $OUTPUT->footer();
