<?php
require_once('../../config.php');
require_once(__DIR__ . '/lib.php');

require_login();
global $CFG, $USER, $PAGE;
$PAGE->set_heading('Course Requests');
$PAGE->set_title('Course Request');
$PAGE->set_pagelayout('standard');
$PAGE->requires->css('/local/public/css/instructor.css');
$PAGE->requires->css('/local/public/css/bootstrap.min.css');
$PAGE->requires->css('/local/public/css/font-awesome.min.css');
$PAGE->requires->css('/local/public/css/style.css');
$PAGE->requires->js('/local/public/amd/src/instructor.js');


$instructor_roleid = $DB->get_field('role', 'id', ['shortname' => 'manager']); // instructor role id
if (!user_has_role_assignment($USER->id, $instructor_roleid)) {
   redirect(new moodle_url('/my/'));
}

$draftmodules = $DB->get_records('course', ['usercreated' => $USER->id]);
$draftedcourses = $DB->get_records_sql("SELECT cc.* FROM {course_categories} cc JOIN {request_subcategory} rs ON rs.subcategory_id = cc.id  WHERE cc.visible = 0 AND (rs.status = 0 OR rs.status = 4  OR rs.status = 5   OR rs.status = 6) AND rs.userid = $USER->id ORDER BY cc.id DESC");
$PAGE->navbar->add('Course Requests','');
echo $OUTPUT->header();

$draftedcoursescount = 1;
foreach ($draftedcourses as $draftedcourses_value) {
   $pendingrequest = false;
   $visibility = false;
   $status = '';

         $trackname = $DB->get_record_sql("SELECT * FROM {course_categories} WHERE id = $draftedcourses_value->parent AND parent = 0");
         if ($DB->record_exists('request_subcategory', ['subcategory_id' => $draftedcourses_value->id, 'status' => 4])) {
            $status = 'To be Revised';
            $class = 'status-revised';

         }
         elseif ($DB->record_exists('request_subcategory', ['subcategory_id' => $draftedcourses_value->id, 'status' => 5])) {
            $status = 'Rejected';
            $class = 'status-red';

         }
         elseif ($DB->record_exists('request_subcategory', ['subcategory_id' => $draftedcourses_value->id, 'status' => 6])) {
            $status = 'Approved';
            $class = 'status-darkgreen';

         }
         else {
            $status = 'Pending for approval';
            $class = 'status-pending';

         }


         // if ($modules->visible == 0) {
         //    if ($DB->record_exists('reject_course', ['course_id' => $modules->id, 'status' => 0])) { 
         //       $status = 'Rejected';

         //    }
         //    elseif ($DB->record_exists('reject_course', ['course_id' => $modules->id, 'status' => 2])) {
         //       $status = 'Drafted';

         //    }
         //    elseif ($DB->record_exists('reject_course', ['course_id' => $modules->id, 'status' => 3])) {
         //       $status = 'Reviewed';

         //    }
         //    else {
         //       $pendingrequest = true;
             
         //    }
         // }

         // if ($modules->visible == 1) { 
         //    $pendingrequest = false;
         //    $visibility = true;
         // }

         $courserequest[] = [
            'modulecount'=>$draftedcoursescount,
            'coursename'=>$draftedcourses_value->name,
            'trackname'=>$trackname->name,
            'status'=>$status,
            'class'=>$class,
            'trackid'=>$trackname->id
            // 'pendingrequest'=>$pendingrequest
            // 'visibility'=>$visibility

         ];

         $draftedcoursescount++;
      
   
}

$data = [
'request'=>$courserequest
];
echo $OUTPUT->render_from_template('local_public/instructor_courserequest',$data);
echo $OUTPUT->footer();
?>

