<?php
require_once('../../config.php');
global $trackid, $USER;
require_login();
$moduleid = required_param('id', PARAM_INT);
$trackid = required_param('trackid', PARAM_INT);

$title = 'My Modules';
$pagetitle = $title;
$PAGE->set_title($title);
$PAGE->set_heading($title);
$PAGE->set_pagelayout('standard');
$PAGE->requires->css('/local/report/css/modules.css');
$PAGE->requires->css('/local/report/css/bootstrap.min.css');
$PAGE->requires->css('/local/report/css/font-awesome.min.css');
$PAGE->requires->js('/local/report/amd/src/module.js');

echo $OUTPUT->header();

$data = $DB->get_records_sql("SELECT mc.* FROM {course} mc  where mc.category = $moduleid AND (mc.id IN (SELECT courseid FROM {enrol} WHERE enrol = 'self' AND status = 0) OR mc.id IN (SELECT er.courseid FROM {enrol} er JOIN {user_enrolments} ue ON ue.enrolid = er.id AND ue.userid = $USER->id))");

function get_course_image($courseid)
{
   global $COURSE;
   $url = '';

   $context = context_course::instance($courseid);
   $fs = get_file_storage();
   $files = $fs->get_area_files($context->id, 'course', 'overviewfiles', 0);

   foreach ($files as $f) {
      if ($f->is_valid_image()) {
         $url = moodle_url::make_pluginfile_url($f->get_contextid(), $f->get_component(), $f->get_filearea(), null, $f->get_filepath(), $f->get_filename(), false);
      }
   }

   return $url;
}
foreach ($data as $datavalue) {
if ($DB->record_exists('course',['id'=>$datavalue->id,'visible'=>1])) {
   # code...

   $topics = $DB->count_records('course_sections', ['course' => $datavalue->id]);
   $context = context_course::instance($datavalue->id);
   // if (is_enrolled($context, $USER->id, '', true)) {
      $courseid = $datavalue->id;

      $url = get_course_image($courseid);
      if (!$url) {
         $url = 'image/courses.jpg';
      }

      
    $modulename[]=['module_name'=>$datavalue->fullname,'moduleimage'=>$url,'subtopiccount'=>$topics,'starttext'=>substr(strip_tags($datavalue->summary),0,50),'endtext'=>substr(strip_tags($datavalue->summary),50,strlen(strip_tags($datavalue->summary))),'moduleid'=>$datavalue->id];

   }
}
$data = [
   'modulename' =>$modulename,
   'trackid' =>$trackid
];
echo $OUTPUT->render_from_template('local_report/mymodules',$data);
 echo $OUTPUT->footer(); 
?>
