<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for plugin 'fileconverter_googledrive'
 *
 * @package   fileconverter_googledrive
 * @copyright 2017 Damyon Wiese
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'Google Drive';
$string['disabled'] = 'Disabled';
$string['issuer'] = 'OAuth 2 service';
$string['issuer_help'] = 'The OAuth 2 service used to access Google Drive.';
$string['privacy:metadata:fileconverter_googledrive:externalpurpose'] = 'This information is sent to Google Drive API in order the file to be converted to an alternative format. The file is temporarily kept on Google Drive and gets deleted after the conversion is done.';
$string['privacy:metadata:fileconverter_googledrive:filecontent'] = 'The content of the file.';
$string['privacy:metadata:fileconverter_googledrive:filemimetype'] = 'The MIME type of the file.';
$string['privacy:metadata:fileconverter_googledrive:params'] = 'The query parameters passed to Google Drive API.';
$string['test_converter'] = 'Test this converter is working properly.';
$string['test_conversion'] = 'Test document conversion';
$string['test_conversionready'] = 'This document converter is configured properly.';
$string['test_conversionnotready'] = 'This document converter is not configured properly.';
$string['test_issuerinvalid'] = 'The OAuth service in the document converter settings is set to an invalid value.';
$string['test_issuernotenabled'] = 'The OAuth service set in the document converter settings is not enabled.';
$string['test_issuernotconnected'] = 'The OAuth service set in the document converter settings does not have a system account connected.';
$string['test_issuernotset'] = 'The OAuth service needs to be set in the document converter settings.';
