<?php
require_once('../../config.php');
global $DB, $OUTPUT, $PAGE;
require_login();

if (!is_siteadmin()) {
  redirect(new moodle_url('/my/'));
}


$studentid = required_param('id', PARAM_INT);

$moduleid = required_param('moduleid', PARAM_INT);

$trackid = required_param('trackid', PARAM_INT);

$courseid = required_param('courseid', PARAM_INT);

$userlastaccess = $DB->get_record_sql("SELECT * FROM {user_lastaccess} WHERE userid = $studentid AND courseid = $moduleid");
if ($userlastaccess) {
  $userlastaccess_time =  date("d/m/y",$userlastaccess->timeaccess);

}
else {
  $userlastaccess_time = "Not Open Yet";
}
$totalenrol_courses =count(enrol_get_users_courses($studentid, $onlyactive = false, $fields = null, $sort = null)); 

$enrolid = $DB->get_record_sql("SELECT * FROM {enrol} WHERE courseid = $moduleid");
$record = $DB->get_record_sql("SELECT * FROM {user} WHERE id = $studentid");
$trackrecord = $DB->get_record_sql("SELECT * FROM {course_categories} WHERE id = $trackid");
$courserecord = $DB->get_record_sql("SELECT * FROM {course_categories} WHERE id = $courseid");
$modulerecord = $DB->get_record_sql("SELECT * FROM {course} WHERE id = $moduleid");
$student_enrolment_time = $DB->get_record_sql("SELECT * FROM {user_enrolments} WHERE userid = $studentid AND enrolid = $enrolid->id ");
$student_enrolment_date = date("d/m/y ",$student_enrolment_time->timecreated);


//code for track graph

$total_completed_courses_within_track = [];
$total_completed_track = [];


$total_inprogress_courses_within_track = [];
$total_inprogress_track = [];


  $allcourses = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE parent = $trackid");

  $total_allcourses = count($allcourses);

  foreach ($allcourses as $allcourses1) {
    $allmodules = $DB->get_records_sql("SELECT * FROM {course} WHERE category = $allcourses1->id");
    $totalallmodules = count($allmodules);
    $total_completed_module_within_track = [];
    $total_inprogress_module_within_track = [];
    foreach ($allmodules as $allmodules1) {
      $course_object = $DB->get_record('course', ['id' => $allmodules1->id]);
      $check = core_completion\progress::get_course_progress_percentage($course_object, $studentid);
      if ($check == 100) {
        $total_completed_module_within_track[] = $course_object->id;
      }
 
      if ($check > 0 && $check < 100) {
        $total_inprogress_module_within_track[] = $course_object->id;
      }
    }
    
    if (count($total_inprogress_module_within_track) > 0) {
      $total_inprogress_courses_within_track[] = $allcourses1->id;
    }
    if (count($total_completed_module_within_track) == $totalallmodules) {
      $total_completed_courses_within_track[] =  $allcourses1->id;
     
    }
  }


$totalcompletedtrack = (count($total_completed_courses_within_track) / $total_allcourses) * 100;
$totalinprogresstrack = (count($total_inprogress_courses_within_track) / $total_allcourses) * 100;
$totalnotstartyet = 100 - ($totalcompletedtrack + $totalinprogresstrack);


// end

//code for course graph
$total_completed_module_within_course = [];

$total_inprogress_module_within_course = [];

$allcoursemodules = $DB->get_records_sql("SELECT * FROM {course} WHERE  category = $courseid");
$totalallcoursemodules = count($allcoursemodules);


foreach ($allcoursemodules as $allcoursemodules1) {
  $course_object1 = $DB->get_record('course', ['id' => $allcoursemodules1->id]);

  $check1 = core_completion\progress::get_course_progress_percentage($course_object1, $studentid);

  if ($check1 == 100) {
    $total_completed_module_within_course[] =  $course_object1->id;
  }
  if ($check1 > 0 && $check1 < 100) {
    $total_inprogress_module_within_course[] =  $course_object1->id;
  }
}
$count_total_completed_module_within_course = (count($total_completed_module_within_course) / $totalallcoursemodules) * 100;
$count_total_inprogress_module_within_course = (count($total_inprogress_module_within_course) / $totalallcoursemodules) * 100;
$count_total_notyetstart_module_within_course = 100 - ($count_total_completed_module_within_course + $count_total_inprogress_module_within_course);
//end

$total_completed_module = [];

// count of completed module
// $course_moduleid = $DB->get_records('course_modules', ['course' => $moduleid]);
$course_moduleid = $DB->get_records_sql("SELECT * FROM {course_modules} WHERE course = $moduleid AND module != 10");

$total_module = count($course_moduleid);
foreach ($course_moduleid as $course_moduleid1) {
  $completed_module = $DB->get_record_sql("SELECT * FROM {course_modules_completion} WHERE userid = $studentid AND completionstate = 1 AND coursemoduleid = $course_moduleid1->id");
  if ($completed_module->id) {
    $total_completed_module[] = $completed_module->id;
  }
}
$total_completed_module1 = (count($total_completed_module) / $total_module) * 100;

//end 

//count of inprogress module
foreach ($course_moduleid as $course_moduleid2) {
  $inprogress_module1 = $DB->get_record_sql("SELECT * FROM {course_modules_completion} WHERE userid = $studentid AND completionstate = 0 AND coursemoduleid = $course_moduleid2->id");
  if ($inprogress_module1->id) {
    $total_inprogress_module[] = $inprogress_module1->id;
  }
}
$total_inprogress_module1 = (count($total_inprogress_module) / $total_module) * 100;
//end

$total_not_start_yet = 100 - ($total_completed_module1 + $total_inprogress_module1);


$PAGE->set_title('Student Detail');
$PAGE->set_heading('Student Detail');
$PAGE->set_pagelayout('standard');
echo $OUTPUT->header();

?>
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- <title>Labz LMS</title> -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
  <link rel="stylesheet" type="text/css" href="style.css">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/5.0.0/normalize.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta2/css/all.min.css" integrity="sha512-YWzhKL2whUzgiheMoBFwW8CKV4qpHQAEuvilg9FAn5VJUDwKZZxkJNuGM4XkWuk94WCrrwslk8yWNGmY1EduTA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500&display=swap" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.5.0/Chart.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js"></script>
  <style type="text/css">
    #region-main{
      padding: 0px !important;
      background: #1e1e29;
    }
    
    .box-1,.flex{
      background: #1e1e29 !important;
    }
    .graph{
      background: #27293d !important;
    }
    .stats-container{
      background: #27293d;
      color: #fff;
      min-width: 280px;
    }
    .branch{
      color: #fff;
    }
    .tbody tr td{
      color: #fff !important;
    }
    .overflow{
      overflow-x: scroll;
    }
    canvas{
      background: inherit;
    }
    #myChart, #myChart2, canvas{
      height: auto;
    }
  </style>
</head>

<body>
  <input type="hidden" id="completed" value="<?php echo $total_completed_module1; ?>">
  <input type="hidden" id="inprogress" value="<?php echo $total_inprogress_module1; ?>">
  <input type="hidden" id="notstart" value="<?php echo $total_not_start_yet; ?>">

  <input type="hidden" id="completedtrack" value="<?php echo $totalcompletedtrack; ?>">
  <input type="hidden" id="inprogresstrack" value="<?php echo $totalinprogresstrack; ?>">
  <input type="hidden" id="notstarttrack" value="<?php echo $totalnotstartyet; ?>">


  <input type="hidden" id="completedcourse" value="<?php echo $count_total_completed_module_within_course; ?>">
  <input type="hidden" id="inprogresscourse" value="<?php echo $count_total_inprogress_module_within_course; ?>">
  <input type="hidden" id="notstartcourse" value="<?php echo $count_total_notyetstart_module_within_course; ?>">


  <div class="box-1 mb-2">
    <div class="flex">
      <div class="stats-container red">
        <div class="stats">
          <i class="fa-solid fa-user fa-3x icon"></i>

          <h4 class="date"><?php echo $student_enrolment_date;?><br></h4>
          <p>Enrolment date</p>
        </div>
      </div>
      <div class="stats-container blue">
        <i class="fa-solid fa-calendar fa-3x icon"></i>

        <h4 class="date"><?php echo $userlastaccess_time;?><br></h4>
        <p>Last Access Date</p>
      </div>
      <div class="stats-container orange">
        <i class="fa-solid fa-clock fa-3x icon"></i>
        <h4 class="date">19111 D<br> 6 H 39 M</h4>
        <p>Total time</p>
      </div>
      <div class="stats-container blue">
        <i class="fa-solid fa-book fa-3x icon"></i>
        <h4 class="date"><?php echo $totalenrol_courses;?></h4>
        <p>Active courses</p>
      </div>
    </div>

    <div class="row table-one mt-5">
      <div class="col-md-6">
        <div class="branch" style="border-color: #e63946;">
        <div class="country-flex">
          <p>Track</p>
          <p><?php echo $trackrecord->name;?></p>
        </div>
        </div>
        <div class="branch" style="border-color: #0096c7;">
        <div class="country-flex">
          <p>Course</p>
          <p><?php echo $courserecord->name;?></p>
        </div>
        </div>
        <div class="branch" style="border-color: #fca311;">
        <div class="country-flex">
          <p>Module</p>
          <p><?php echo $modulerecord->fullname;?></p>
        </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="branch" style="border-color: #fca311;">
        <div class="country-flex">
          <p>City</p>
          <p><?php echo $record->city;?></p>
        </div>
        </div>
        <div class="branch" style="border-color: #0096c7;">
          <div class="country-flex">
            <p>Country</p>
            <p><?php echo $record->country;?></p>
          </div>
        </div>
        <div class="branch" style="border-color: #e63946;">
          <div class="country-flex">
            <p>Mailing Address</p>
            <p><?php echo $record->email;?></p>
          </div>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-md-6 mt-5">
        <div class="box-1 graph">
          <div class="box-inside">
            <div class="my-course">
              <h5>Progress</h5>
            </div>
          </div>
          <canvas id="myChart1" style="width:100%;max-width:600px"></canvas>
        </div>
      </div>

      <div class="col-md-6 mt-5">
        <div class="box-1 graph">
          <div class="box-inside">
            <div class="my-course">
              <h5>See All Activity</h5>
            </div>
          </div>
          <canvas id="myChart" style="width:100%;max-width:600px"></canvas>
        </div>
      </div>

      <div class="col-md-6 mt-5">
        <div class="box-1 graph">
          <div class="box-inside">
            <div class="my-course">
              <h5>See All Activity</h5>
            </div>
          </div>
          <canvas id="myChart3" style="width:100%;max-width:600px"></canvas>
        </div>
      </div>
    </div>


    <div class="flx mt-5">
      <div class="container-fluid">


        <div class="overflow">
          <table class="table table-striped table-class" id="table-id3">

            <tr>
              <th>S.No.</th>
              <th>Course Code</th>
              <th>Course Name</th>
              <th>User Status</th>
              <th>Enrolled</th>
              <th>First Access Date</th>
              <th>Course Completion</th>
              <th>Score</th>
            </tr>

            <tbody class="tbody">
              <tr>
                <td>1</td>
                <td>LMS Demo VC</td>
                <td>VC- LMS Demo</td>
                <td>In progress</td>
                <td>16/05/20 01:39:08</td>
                <td>16/05/20</td>
                <td>-</td>
                <td>-</td>
              </tr>
              <tr>
                <td>2</td>
                <td>Thermodynamics</td>
                <td>Thermodynamics</td>
                <td>In progress</td>
                <td>16/05/20 01:39:08</td>
                <td>16/05/20</td>
                <td>-</td>
                <td>-</td>
              </tr>
              <tr>
                <td>3</td>
                <td>HRH Next - LMS Demo</td>
                <td>HRH Next - LMS Demo</td>
                <td>In progress</td>
                <td>16/05/20 01:39:08</td>
                <td>16/05/20</td>
                <td>-</td>
                <td>-</td>
              </tr>
            </tbody>


          </table>

        </div>
      </div>
    </div>
    <script>
      $(document).ready(function() {
        $(".bar").click(function() {
          $(".left-position, .right-position").toggleClass('addclass addmarginclass');
        });
      });
    </script>
    <script>
      $(document).ready(function() {
        $("div i").hover(function() {

          // var $this = $(this);
          // $this.nextAll().removeClass('fa-star').addClass( "fa-star-o" );
          // $this.prevUntil("h1").removeClass( "fa-star-o" ).addClass('fa-star');
          // $this.removeClass( "fa-star-o" ).addClass('fa-star');
        });

        //**on mouseOut** change back to fa-star-o OR the result of the click event

        $("div i").mouseout(function() {

          var select = $('.active');
          select.nextAll().removeClass('fa-star').addClass('fa-star-o');
          select.prevUntil("h1").removeClass('fa-star-o').addClass('fa-star');
          select.removeClass('fa-star-o').addClass('fa-star');

        });

        //on Click change star to fa-star and change color to red (prevAll)

        $("div i").click(function() {
          $(this).addClass('active').siblings().removeClass('active');
          $(this).attr("style", "color:#ffd700");
          $(this).prevUntil("h1").css("color", "#ffd700");
          $(this).nextAll().css("color", "#ffd700");

        });



      });
    </script>
    <script>
      $(function() {

        // Developed by IceMaD
        // marcduboc.fr
        // https://github.com/MarcDuboc/qtpie

        // Thanks to Anders Grimsrud for the base : https://codepen.io/agrimsrud/pen/EmCoa

        qtpie = {

          init: function(options) {

            var defaultOptions = {
              id: '#qtpie',
              defaultMsg: '10 BEGIN 0(0%)',
              radius: 70,
              list: false,
              hover: true
            }
            options = $.extend({}, defaultOptions, options);

            // Draw paths
            base = 0;
            $paths = $(options.id).find('path');
            $paths.each(function(index, el) {
              deg = 3.61 * $(this).attr('data-pie');
              // 3.61 instead of 3.6 to fix little svg render bug
              qtpie.draw({
                slice: $(this),
                degree: deg,
                base: base
              });
              base += parseInt(deg);
            });

            // Inside
            $(options.id).find('circle').attr('r', options.radius);
            $(options.id).find('div').append('<div class="qtpieInside">' + options.defaultMsg + '</div>').find('circle').css('fill', $('body').css('background-color'));

            // Hover events
            if (options.hover) {
              $paths.hover(function(event) {
                $current = $(this);
                $inside = $current.parent().parent().find('.qtpieInside')

                $inside.stop().fadeOut(200, function() {
                  $inside
                    .css('color', $current.css('fill'))
                    .html($current.attr('data-desc'))
                    .fadeIn(200);
                });
              }, function() {
                $current = $(this);
                $inside = $current.parent().parent().find('.qtpieInside')

                $inside.stop().fadeOut(200, function() {
                  $inside
                    .removeAttr('style')
                    .html(options.defaultMsg)
                    .fadeIn(200);
                });
                $(this)
              });
            };

            // List generation (bootstrap style)
            if (options.list) {
              var list = '';
              $paths.each(function(index, el) {
                list += '<li><span class="dot" style="background-color:' + $(this).css('fill') + ';"></span>' + $(this).attr('data-desc') + '</li>';
              });
              $(options.id).append('<ul>' + list + '</ul>');
            };

            // Display at the dn
            $(options.id).show();
          },

          draw: function(options) {

            var defaultOptions = {
              slice: null,
              degree: 0,
              base: 0
            };
            options = $.extend({}, defaultOptions, options);

            var rayon = (options.degree * Math.PI / 180),
              x = Math.sin(rayon) * 100,
              y = Math.cos(rayon) * -100,
              mid = (options.degree > 180) ? 1 : 0,
              anim = 'M 0 0 v -100 A 100 100 1 ' + mid + ' 1 ' + x + ' ' + y + ' z';
            options.slice.attr('d', anim).attr('transform', 'translate(100, 100) rotate(' + base + ')');
          }
        }
        qtpie.init({

        });
        qtpie.init({
          id: '#qtpie-list',
          defaultMsg: 'But not me !',
          radius: 70,
          list: true,
          hover: false
        });
      });
    </script>

    <script>
      var com = $("#completed").val();
      var inprog = $("#inprogress").val();
      var notstart = $("#notstart").val();

      var xValues = ["Completed", "Inprogress", "Not Start Yet"];
      var yValues = [Math.ceil(com), Math.ceil(inprog), Math.ceil(notstart)];
      var barColors = [
        "#2b5797",
        "#FFA500",
        "#A020F0"
      ];

      new Chart("myChart1", {
        type: "doughnut",
        data: {
          labels: xValues,
          datasets: [{
            backgroundColor: barColors,
            data: yValues
          }]
        },
        options: {
           legend: {
                display: true,
                labels: {
                    fontColor: "#fff"
                }
              },
          title: {
            display: true,
            text: "Module Report",
             fontColor: "#fff"
          }
        }
      });
    </script>



    <script>
      var comtrack = $("#completedtrack").val();
      var inprogtrack = $("#inprogresstrack").val();
      var notstart_track = $("#notstarttrack").val();

      var xValues = ["Completed", "IN Progress", "Not Start Yet"];
      var yValues = [Math.ceil(comtrack), Math.ceil(inprogtrack), Math.ceil(notstart_track)];
      var barColors = [
        "#2b5797",
        "#FFA500",
        "#A020F0"
      ];

      new Chart("myChart", {
        type: "doughnut",
        data: {
          labels: xValues,
          datasets: [{
            fill: false,
            lineTension: 0,
            backgroundColor: barColors,
            data: yValues
          }]
        },
        options: {
          legend: {
                display: true,
                labels: {
                    fontColor: "#fff"
                }
              },
          title: {
            display: true,
            text: "Track Report",
            fontColor: "#fff"
          }
        }
      });
    </script>


    <script>
      var commodule = $("#completedcourse").val();
      var inprogmodule = $("#inprogresscourse").val();
      var notstart_module = $("#notstartcourse").val();
      var xValues = ["Completed", "IN Progress", "Not Start Yet"];
      var yValues = [Math.ceil(commodule), Math.ceil(inprogmodule), Math.ceil(notstart_module)];
      var barColors = [
        "#2b5797",
        "#FFA500",
        "#A020F0"
      ];

      new Chart("myChart3", {
        type: "doughnut",
        data: {
          labels: xValues,
          datasets: [{
            fill: false,
            lineTension: 0,
            backgroundColor: barColors,
            data: yValues
          }]
        },
        options: {
           legend: {
                display: true,
                labels: {
                    fontColor: "#fff"
                }
              },
          title: {
            display: true,
            text: "Course Report",
            fontColor: "#fff"
          }
        }
      });
    </script>


</body>

</html>

<?php

echo $OUTPUT->footer(); ?>