<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Upgrade script for the quiz module.
 *
 * @package    mod_quiz
 * @copyright  2006 Eloy Lafuente (stronk7)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Quiz module upgrade function.
 * @param string $oldversion the version we are upgrading from.
 */

function xmldb_local_public_install() {
    global $DB;
    $dbman = $DB->get_manager();
    
    $table = new xmldb_table('user');
    $field = new xmldb_field('usercreated', XMLDB_TYPE_INTEGER, '10', null, null, null, '0',
        'moodlenetprofile'); // You'll have to look up the definition to see what other params are needed.
    
    if (!$dbman->field_exists($table, $field)) {
    $dbman->add_field($table, $field);
    }

        
    $table = new xmldb_table('course');
    $field = new xmldb_field('usercreated', XMLDB_TYPE_INTEGER, '10', null, null, null, '0',
        'showcompletionconditions'); // You'll have to look up the definition to see what other params are needed.
    
    if (!$dbman->field_exists($table, $field)) {
    $dbman->add_field($table, $field);
    }

        
    $table = new xmldb_table('course_categories');
    $field = new xmldb_field('text', XMLDB_TYPE_TEXT, '10', null, null, null, '0',
        'theme'); // You'll have to look up the definition to see what other params are needed.
    
    if (!$dbman->field_exists($table, $field)) {
    $dbman->add_field($table, $field);
    }


    $table = new xmldb_table('course_categories');
    $field = new xmldb_field('usercreated', XMLDB_TYPE_INTEGER, '10', null, null, null, '0',
        'path'); // You'll have to look up the definition to see what other params are needed.
    
    if (!$dbman->field_exists($table, $field)) {
    $dbman->add_field($table, $field);
    }

    
    // $table = new xmldb_table('logstore_standard_log');
    // $field = new xmldb_field('browsername', XMLDB_TYPE_TEXT, '100', null, null, null, '0',
    //     'realuserid'); // You'll have to look up the definition to see what other params are needed.
    
    // if (!$dbman->field_exists($table, $field)) {
    // $dbman->add_field($table, $field);
    // }



}

